#version 430 core

uniform mat4 ProjectionMatrix;

uniform vec3 XAxis;
uniform vec3 YAxis;
uniform float radiusScale;

in vec3 gs_light_params[1]; // radius
in vec3 gs_light_color[1];

out vec2 uv;
out vec3 wpos;
out vec4 color;

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

#define EMIT_VERTEX(VTX, UV) \
	uv = (UV); \
	color = vec4(gs_light_color[0]*alpha, alpha); \
	wpos = VTX; \
	gl_Position = ProjectionMatrix * vec4((VTX), 1.0); \
	EmitVertex()

void main()
{
	float radius = gs_light_params[0].y*radiusScale;
	if ( radius <= 0.0 ) return;

	vec4 pos = gl_in[0].gl_Position;
	float dist = dot(vec3(0.0, 0.0, -1.0), pos.xyz ) - 1.0;
	float alpha = smoothstep(0.0, 1.0, dist);
	if( alpha <= 0.0 ) return;

	vec3 a = pos.xyz + (XAxis + YAxis)*radius;
	vec3 b = pos.xyz + (YAxis - XAxis)*radius;
	vec3 c = pos.xyz + (-XAxis - YAxis)*radius;
	vec3 d = pos.xyz + (XAxis - YAxis)*radius;

	EMIT_VERTEX(a, vec2(1.0, 0.0));
	EMIT_VERTEX(b, vec2(0.0, 0.0));
	EMIT_VERTEX(d, vec2(1.0, 1.0));
	EMIT_VERTEX(c, vec2(0.0, 1.0));

	EndPrimitive();
}
