#version 430 core

uniform sampler2D diffusemap;
uniform sampler2D specularmap;
uniform sampler2D normalmap;

in vec3 normal;
in vec4 tangent;
in vec2 uv;

#include <deferred/gbuffer_write_include.frag>


void main()
{
	vec3 n = normalize(normal);
	vec3 t = normalize(tangent.xyz);
	vec3 b = normalize(cross(normal, tangent.xyz) * tangent.w);
	
	vec3 baseNormal = normalize(normal);
	vec3 bn = texture(normalmap, uv).xyz*2.0 - vec3(1.0);
	mat3 mr = mat3(t, b, n);
	n = normalize(mr * normal);

	gb_diffuse.rgb = texture(diffusemap, uv).rgb;
	gb_diffuse.a = 0.0;

	gb_specular = texture(specularmap, uv);

	gb_normal.xyz = n;
	gb_normal.w = 0.0;

	gb_light = vec4(0.0);
}
