#version 430 core

uniform sampler2D diffusemap;
uniform sampler2D specularmap;

in vec2 pos_zw;
in vec3 normal;
in vec2 uv;

#include <deferred/gbuffer_write_include.frag>

void main()
{
	gb_diffuse.rgb = texture(diffusemap, uv).rgb;
	gb_diffuse.a = 0.0;

	gb_specular = texture(specularmap, uv);

	gb_normal.xyz = normalize(normal);
	gb_normal.w = 0.0;

	gb_light = vec4(0.0);
}
