// inverse projection coeffs
uniform float projCoeffs[5];

vec3 calc_position(in vec2 uv_pos, in float d)
{
	vec4 wpos;
	wpos.x = (uv_pos.x - 0.5)*2.0*projCoeffs[0];
	wpos.y = (uv_pos.y - 0.5)*2.0*projCoeffs[1];
	wpos.z = projCoeffs[2];
	wpos.w = d*projCoeffs[3] + projCoeffs[4];
	return wpos.xyz / wpos.w;
}

/*
uniform mat4 ProjectionMatrixInverse;

vec3 calc_position(in vec2 uv_pos, in float d)
{
	vec4 wpos = vec4((uv_pos.x - 0.5)*2.0, (uv_pos.y - 0.5)*2.0, d, 1.0);

	wpos = ProjectionMatrixInverse * wpos;

	return wpos.xyz / wpos.w;
}
*/
