#version 430 core

uniform mat4 ModelViewMatrix;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 2) in vec3 COLOR;
layout (location = 4) in vec3 TEX_COORD;

out vec4 gs_light_plane;
out vec3 gs_light_coeff; // size, length, intensity
out vec3 gs_color;

void main()
{
	vec3 p0 = vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	vec3 p1 = vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	vec3 dir = normalize(p1 - p0);
	gs_light_plane.xyz = dir;
	gs_light_plane.w = -dot(dir, p0);
	gs_light_coeff = NORMAL;
	gs_color = COLOR;
	gl_Position = vec4(POSITION, 1.0);
}

