#version 430 core

in vec3 gs_light_color[1];

out vec3 color;

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

#define EMIT(VTX) \
	color = gs_light_color[0]; \
	gl_Position = VTX; \
	EmitVertex()

void main()
{
	vec3 dir = normalize(gl_in[0].gl_Position.xyz);

	EMIT(vec4(1.0, 1.0, 1.0, 1.0));
	EMIT(vec4(-1.0, 1.0, 1.0, 1.0));
	EMIT(vec4(1.0, -1.0, 1.0, 1.0));
	EMIT(vec4(-1.0, -1.0, 1.0, 1.0));

	EndPrimitive();
}
