#version 420

uniform sampler2D tex;
uniform vec2 delta;

in vec2 out_TexCoord;
out vec4 fragColor;

void main()
{
  /* get vertex info */
  vec4 info = texture2D(tex, out_TexCoord);

  /* update the normal */
  vec3 dx = vec3(delta.x, texture2D(tex, vec2(out_TexCoord.x + delta.x, out_TexCoord.y)).r - info.r, 0.0);
  vec3 dy = vec3(0.0, texture2D(tex, vec2(out_TexCoord.x, out_TexCoord.y + delta.y)).r - info.r, delta.y);
  info.ba = normalize(cross(dy, dx)).xz;

  fragColor = info;
}