#version 420

uniform sampler2D texture;
uniform float blaat;
uniform vec2 delta;

in vec2 out_TexCoord;

out vec4 fragColor;

    // uniform vec2 delta;
    // varying vec2 coord;


void main() 
{
  //vec2 delta = vec2(10.1, 10.1);

  /* get vertex info */
  vec4 info = texture2D(texture, out_TexCoord);
  
  /* calculate average neighbor height */
  vec2 dx = vec2(delta.x, 0.0);
  vec2 dy = vec2(0.0, delta.y);
  float average = (
    texture2D(texture, out_TexCoord - dx).r +
    texture2D(texture, out_TexCoord - dy).r +
    texture2D(texture, out_TexCoord + dx).r +
    texture2D(texture, out_TexCoord + dy).r
  ) * 0.25;
  
  /* change the velocity to move toward the average */
  info.g += (average - info.r) * 2.0;
  
  /* attenuate the velocity a little so waves do not last forever */
  info.g *= 0.0995;
  
  /* move the vertex along the velocity */
  info.r += info.g;
  info.b = 0.5f;
  fragColor = info;
}
