#version 420

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform sampler2D tex;
in vec3 in_Vertex;
in vec3 in_Normal;
in vec2 in_TexCoord;
out float watercolor;
out vec2 out_TexCoord;

void main()
{
	vec3 position = in_Vertex;
	out_TexCoord = in_TexCoord;

    vec4 info = texture2D(tex, in_Vertex.xy * 0.5 + 0.5);
    watercolor = ((info.r + info.g + info.b) / 10);
    position.z += watercolor;

	gl_Position = projectionMatrix * modelViewMatrix * vec4(position,1.0);
}