#version 420

uniform sampler2D tex;
uniform sampler2D colorbuffer;


in vec2 out_TexCoord;

out vec4 fragColor;

uniform float time;
uniform float near_dist;
uniform float far_dist;

// grabbed from the interwebs!
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

float linearize_depth_value(float depth)
{
	float linear_depth = (2 * near_dist) / (far_dist + near_dist - depth * (far_dist - near_dist));
	return linear_depth;
}

void main()
{
	vec2 tc = out_TexCoord;
 
	vec4 color = texture2D(colorbuffer,tc);

	float pixel = texture2D(tex,tc).r;
	float depth = linearize_depth_value(pixel);

//	float angle = rand(vec2(gl_FragCoord.xy)+vec2(time,time));
	float angle = rand(vec2(gl_FragCoord.xy));

	const float radius = 100;

	const float HSTEP = 1.0 / 1920 * ((pixel - 1) * radius);
	const float VSTEP = 1.0 / 1080 * ((pixel - 1) * radius);



 
	vec2 sample1 = vec2(-1,  0);
	vec2 sample2 = vec2( 1,  0);
	vec2 sample3 = vec2( 0,  1);
	vec2 sample4 = vec2( 0, -1);

	vec2 rotation = vec2(cos(angle), sin(angle));

	sample1 *= rotation * vec2(HSTEP, VSTEP);
	sample2 *= rotation * vec2(HSTEP, VSTEP);
	sample3 *= rotation * vec2(HSTEP, VSTEP);
	sample4 *= rotation * vec2(HSTEP, VSTEP);

	// sample 4 pixels.
	float s1 = linearize_depth_value(texture2D(tex, tc + sample1).r); // l 
	float s2 = linearize_depth_value(texture2D(tex, tc + sample2).r); // r
	float s3 = linearize_depth_value(texture2D(tex, tc + sample3).r); // t
	float s4 = linearize_depth_value(texture2D(tex, tc + sample4).r); // b

	float ambient = 1.0f;

	float bam1 = abs(depth - s1);
	float bam2 = abs(depth - s2);
	float bam3 = abs(depth - s3);
	float bam4 = abs(depth - s4);

	float bias = 0.02;
	if (bam1 < bias && s1 < depth)
		ambient -= (depth - s1) * 88;
	if (bam2 < bias && s2 < depth)
		ambient -= (depth - s2) * 88;
	if (bam3 < bias && s3 < depth)
		ambient -= (depth - s3) * 88;
	if (bam4 < bias && s4 < depth)
		ambient -= (depth - s4) * 88;
	fragColor = vec4(pow(ambient, 2));
	//fragColor = vec4(depth, depth, depth, 1);
	//fragColor = vec4(ambient, ambient, ambient, 1);
}