#version 420
layout(points) in;
layout(triangle_strip, max_vertices=24) out;


uniform mat4 projectionMatrix;
uniform mat4 modelMatrix;
uniform mat4 viewMatrix;

uniform vec3 camera_position;
uniform vec3 spherepos;

out vec2 tex_coord;

void main()
{

	vec4 worldpos = modelMatrix * gl_in[0].gl_Position;

	float size = 0.3f;
	
	vec4 v1 = vec4(worldpos.x - size, worldpos.y - size, worldpos.z + size, worldpos.w);
	vec4 v2 = vec4(worldpos.x + size, worldpos.y - size, worldpos.z + size, worldpos.w);
	vec4 v3 = vec4(worldpos.x - size, worldpos.y + size, worldpos.z + size, worldpos.w);
	vec4 v4 = vec4(worldpos.x + size, worldpos.y + size, worldpos.z + size, worldpos.w);

	vec4 v5 = vec4(worldpos.x - size, worldpos.y - size, worldpos.z - size, worldpos.w);
	vec4 v6 = vec4(worldpos.x + size, worldpos.y - size, worldpos.z - size, worldpos.w);
	vec4 v7 = vec4(worldpos.x - size, worldpos.y + size, worldpos.z - size, worldpos.w);
	vec4 v8 = vec4(worldpos.x + size, worldpos.y + size, worldpos.z - size, worldpos.w);

	// VOOR
	gl_Position = projectionMatrix * viewMatrix * v1;
	tex_coord = vec2(0,0);
	EmitVertex();

	gl_Position = projectionMatrix * viewMatrix * v2;
	tex_coord = vec2(1,0);
	EmitVertex();

	gl_Position = projectionMatrix * viewMatrix * v3;
	tex_coord = vec2(0,1);
	EmitVertex();

	gl_Position = projectionMatrix * viewMatrix * v4;
	tex_coord = vec2(1,1);
	EmitVertex();	 
	EndPrimitive();


	 // ACHTER
	gl_Position = projectionMatrix * viewMatrix * v6;
	tex_coord = vec2(0,0);
	EmitVertex();

	gl_Position = projectionMatrix * viewMatrix * v5;
	tex_coord = vec2(1,0);
	EmitVertex();

	gl_Position = projectionMatrix * viewMatrix * v8;
	tex_coord = vec2(0,1);
	EmitVertex();

	gl_Position = projectionMatrix * viewMatrix * v7;
	tex_coord = vec2(1,1);
	EmitVertex();	 
	EndPrimitive();

	 // LINKS
	gl_Position = projectionMatrix * viewMatrix * v1;
	tex_coord = vec2(1,0);
	EmitVertex();

	gl_Position = projectionMatrix * viewMatrix * v3;
	tex_coord = vec2(1,1);
	EmitVertex();

	gl_Position = projectionMatrix * viewMatrix * v5;
	tex_coord = vec2(0,0);
	EmitVertex();

	gl_Position = projectionMatrix * viewMatrix * v7;
	tex_coord = vec2(0,1);
	EmitVertex();	 
	EndPrimitive();

	// RECHTS
	gl_Position = projectionMatrix * viewMatrix * v4;
	tex_coord = vec2(0,1);
	EmitVertex();

	gl_Position = projectionMatrix * viewMatrix * v2;
	tex_coord = vec2(0,0);
	EmitVertex();

	gl_Position = projectionMatrix * viewMatrix * v8;
	tex_coord = vec2(1,1);
	EmitVertex();

	gl_Position = projectionMatrix * viewMatrix * v6;
	tex_coord = vec2(1,0);
	EmitVertex();	 
	EndPrimitive();


	// BOVEN
	gl_Position = projectionMatrix * viewMatrix * v3;
	tex_coord = vec2(0,0);
	EmitVertex();

	gl_Position = projectionMatrix * viewMatrix * v4;
	tex_coord = vec2(1,0);
	EmitVertex();

	gl_Position = projectionMatrix * viewMatrix * v7;
	tex_coord = vec2(0,1);
	EmitVertex();

	gl_Position = projectionMatrix * viewMatrix * v8;
	tex_coord = vec2(1,1);
	EmitVertex();	 
	EndPrimitive();


	// ONDER
	gl_Position = projectionMatrix * viewMatrix * v2;
	tex_coord = vec2(1,1);
	EmitVertex();

	gl_Position = projectionMatrix * viewMatrix * v1;
	tex_coord = vec2(0,1);
	EmitVertex();

	gl_Position = projectionMatrix * viewMatrix * v6;
	tex_coord = vec2(1,0);
	EmitVertex();

	gl_Position = projectionMatrix * viewMatrix * v5;
	tex_coord = vec2(0,0);
	EmitVertex();	 
	EndPrimitive();
}