#version 420

uniform sampler2D tex;
uniform vec3 cam_position;

in vec2 tex_coord;

out vec4 fragColor;
in vec4 out_Vertex;



void main()
{
	vec3 vertex = out_Vertex.xyz;

	float dist = distance(vertex, cam_position) / 100;

	vec4 finalColor = texture2D(tex,tex_coord);
	finalColor *= (1 / ((dist)+1));


	//finalColor.g = finalColor.b = 0.0f;
	if (finalColor.a <= 0.1f)
		discard;
	fragColor = finalColor;
}