#version 420

uniform sampler2D colorbuffer;


in vec2 out_TexCoord;

out vec4 fragColor;
const float TOLERANCE = 1100;

vec3 ega_palette[16]  = vec3[](
vec3(0.000, 0.000, 0.000), //black
vec3(0.000, 0.000, 0.627), //dark blue
vec3(0.000, 0.627, 0.000), //dark green
vec3(0.000, 0.627, 0.627), //dark teal
vec3(0.314, 0.314, 0.314), //dark grey
vec3(0.314, 0.314, 0.941), //light blue
vec3(0.314, 0.941, 0.314), //light green
vec3(0.314, 0.941, 0.941), //light teal
vec3(0.627, 0.000, 0.000), //dark red
vec3(0.627, 0.000, 0.627), //dark magenta
vec3(0.627, 0.314, 0.000), //brown
vec3(0.627, 0.627, 0.627), //light grey
vec3(0.941, 0.314, 0.314), //light red
vec3(0.941, 0.314, 0.941), //light pink
vec3(0.941, 0.941, 0.314), //yellow
vec3(0.941, 0.941, 0.941) //white
);

vec3 find_ega_value(vec4 color)
{
	float max_penalty = 1000;
	vec3 out_color;
	for (int i = 0; i < 16; ++i)
	{
		float rdiff = abs(color.r - ega_palette[i].r);
		float gdiff = abs(color.g - ega_palette[i].g);
		float bdiff = abs(color.b - ega_palette[i].b);

		float current_penalty  = rdiff * TOLERANCE;
		 	  current_penalty += gdiff * TOLERANCE;
		 	  current_penalty += bdiff * TOLERANCE;
		if (current_penalty < max_penalty)
		{
			max_penalty = current_penalty;
			out_color = ega_palette[i];
		}
	}
	return out_color;
}



void main()
{
	vec2 tc = out_TexCoord;
 
	vec4 color = texture2D(colorbuffer,tc);

	fragColor = vec4(find_ega_value(color), 1);

}