#version 420

// 1 divided by width and height
uniform vec2 viewport_mul;

// G Buffer
uniform sampler2D normal_buffer;
uniform sampler2D position_buffer;

// Light uniforms
uniform vec3 light_position;
uniform float light_radius;
uniform vec4 light_color;

uniform vec3 camera_position;

in vec2 out_TexCoord;

layout(location = 0) out vec4 diffuse;
layout(location = 1) out vec4 specular;

void main()
{
	vec2 tex_coord = gl_FragCoord.xy * viewport_mul;

	vec4 normal_and_specular = texture2D(normal_buffer, tex_coord);

	vec3 normal = normalize(normal_and_specular.rgb);
	vec3 position = texture2D(position_buffer, tex_coord).rgb;

	float dist = length ( light_position - position );
	float atten = 1.0 - clamp ( dist / light_radius , 0.0 , 1.0);
	if( atten == 0.0)
		discard;

	vec3 incident = normalize ( light_position - position);
	vec3 viewDir = normalize ( camera_position - position);
	
	vec3 halfDir = normalize ( incident + viewDir );
	float lambert = clamp ( dot ( incident , normal ) ,0.0 ,1.0);
	float rFactor = clamp ( dot ( halfDir , normal ) ,0.0 ,1.0);
	
	float sFactor = pow ( rFactor , normal_and_specular.a ); // Shininess in worldnormal.a

	diffuse = vec4 ( light_color. xyz * lambert * atten , 1.0);
	specular = vec4 ( light_color. xyz * sFactor * atten *0.33 ,1.0);
}