#version 420

uniform mat4 model_matrix;
uniform mat4 model_view_projection_matrix;


in vec3 in_Vertex;
in vec3 in_Normal;
in vec3 in_Tangent;
in vec3 in_Cotangent;
in vec2 in_TexCoord;

out vec3 out_Tangent;
out vec3 out_Cotangent;
out vec2 out_TexCoord;
out vec3 normal;
out vec4 position;
out mat3 normal_matrix;

void main()
{
	normal_matrix = mat3(model_matrix);
	normal = normal_matrix * in_Normal;

	position = model_matrix * vec4(in_Vertex, 1.0);

	out_Tangent = normal_matrix * in_Tangent;
	out_Cotangent = normal_matrix * in_Cotangent;
	out_TexCoord = in_TexCoord;
	gl_Position = model_view_projection_matrix * vec4(in_Vertex, 1.0);
}