#version 420

uniform sampler2D diffusemap;
uniform sampler2D normalmap;
uniform vec4 color;


in vec3 out_Tangent;
in vec3 out_Cotangent;
in vec2 out_TexCoord;
in vec3 normal;
in vec4 position;

layout(location = 0) out vec4 frag_color;
layout(location = 1) out vec4 frag_color2;
layout(location = 2) out vec4 frag_color3;
layout(location = 3) out vec4 frag_color4;
layout(location = 4) out vec4 frag_color5;

in mat3 normal_matrix;

void main()
{
	mat3 world_to_tangent = mat3(out_Tangent, out_Cotangent, normal);


	float shininess = 100;
	vec4 diffuse = vec4(texture2D(diffusemap,out_TexCoord).rgb, 0);
	vec3 normalmap_normal = normalize(((texture2D(normalmap,out_TexCoord).rgb) - 0.5) * 2);

	vec3 tangent_normal = world_to_tangent * normalmap_normal;

	frag_color = diffuse;
	frag_color2 = vec4(tangent_normal, shininess);
	frag_color3 = position;
	frag_color4 = vec4(0,0,1,1);
	frag_color4 = vec4(0.2, 0.4, 0.8, 1);
}