#version 420

uniform sampler2D position_buffer;
uniform sampler2D previous_position_buffer;
uniform sampler2D frame_buffer;
uniform float intensity;

uniform mat4 previous_projection_matrix;
uniform mat4 previous_view_matrix;

in vec2 out_TexCoord;

out vec4 fragColor;

const int NUM_SAMPLES = 16;

void main()
{
	vec4 position = previous_view_matrix * vec4(texture2D(position_buffer, out_TexCoord).xyz, 1);
	vec4 previous_position = previous_view_matrix * vec4(texture2D(previous_position_buffer, out_TexCoord).xyz, 1);

	vec4 clip = previous_projection_matrix * position;
	vec4 clip2 = previous_projection_matrix * previous_position;
	clip /= clip.w;
	clip2 /= clip2.w;

	vec2 velocity = clip2.xy - clip.xy;
	velocity /= 36;
	velocity *= intensity;
	vec4 final_color = texture2D(frame_buffer, out_TexCoord);

	vec2 offset = out_TexCoord;
	for (int i = 0; i < NUM_SAMPLES; ++i)
	{
		final_color += texture2D(frame_buffer, offset);
		offset += velocity;
	}

	fragColor = final_color / NUM_SAMPLES;
}