#version 420

uniform sampler2D tex;

in vec2 out_TexCoord;

out vec4 fragColor;

uniform vec2 blur_direction;
uniform float blur_radius;
uniform mat4 blur_kernel;

void main()
{
   vec4 sum = vec4(0.0);
   vec4 pixel = texture2D(tex, out_TexCoord);
 
   float delta = blur_direction * blur_radius;

   // blur in y (vertical)
   // take nine samples, with the distance blurSize between them
   sum += texture2D(tex, vec2(out_TexCoord + (blur_direction * - 7 * blur_radius)))  * blur_kernel[3][1];
   sum += texture2D(tex, vec2(out_TexCoord + (blur_direction * - 6 * blur_radius)))  * blur_kernel[2][1];
   sum += texture2D(tex, vec2(out_TexCoord + (blur_direction * - 5 * blur_radius)))  * blur_kernel[1][1];
   sum += texture2D(tex, vec2(out_TexCoord + (blur_direction * - 4 * blur_radius)))  * blur_kernel[0][1];
   sum += texture2D(tex, vec2(out_TexCoord + (blur_direction * - 3 * blur_radius)))  * blur_kernel[3][0];
   sum += texture2D(tex, vec2(out_TexCoord + (blur_direction * - 2 * blur_radius)))  * blur_kernel[2][0];
   sum += texture2D(tex, vec2(out_TexCoord + (blur_direction * - 1 * blur_radius)))  * blur_kernel[1][0];
   sum += texture2D(tex,  out_TexCoord                                            )  * blur_kernel[0][0];
   sum += texture2D(tex, vec2(out_TexCoord + (blur_direction *   1 * blur_radius)))  * blur_kernel[1][0];
   sum += texture2D(tex, vec2(out_TexCoord + (blur_direction *   2 * blur_radius)))  * blur_kernel[2][0];
   sum += texture2D(tex, vec2(out_TexCoord + (blur_direction *   3 * blur_radius)))  * blur_kernel[3][0];
   sum += texture2D(tex, vec2(out_TexCoord + (blur_direction *   4 * blur_radius)))  * blur_kernel[0][1];
   sum += texture2D(tex, vec2(out_TexCoord + (blur_direction * - 5 * blur_radius)))  * blur_kernel[1][1];
   sum += texture2D(tex, vec2(out_TexCoord + (blur_direction * - 6 * blur_radius)))  * blur_kernel[2][1];
   sum += texture2D(tex, vec2(out_TexCoord + (blur_direction * - 7 * blur_radius)))  * blur_kernel[3][1];
 
   fragColor = mix(pixel, sum, out_TexCoord.x * out_TexCoord.y);
}