#version 420

uniform sampler2D tex;
uniform vec4 color;

in vec2 out_TexCoord;
in vec3 normal;
in vec4 position;

layout(location = 0) out vec4 frag_color;  // Diffuse 
layout(location = 1) out vec4 frag_color2; // World normal
layout(location = 2) out vec4 frag_color3; // World position
layout(location = 3) out vec4 frag_color4; // Glow

void main()
{
	float shininess = 130.1;
	vec4 diffuse = vec4(1);// vec4(texture2D(tex,out_TexCoord).rgb, 1);

	vec4 world_normal = vec4(normal,1);
	world_normal.a = shininess;

	frag_color = diffuse * color;
	frag_color2 = world_normal;
	frag_color3 = position;
	frag_color4 = vec4(0);
}