#version 420

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

in vec3 in_Vertex;
in vec3 in_Normal;
in vec2 in_TexCoord;

out vec2 out_TexCoord;

uniform float tex_multiplier;
uniform float tex_offset;

void main()
{
	vec4 v = vec4(in_Vertex,1.0);

	

	out_TexCoord = in_TexCoord; //(in_TexCoord * vec2(0, tex_multiplier)) + vec2(0, tex_offset);
	out_TexCoord.y *= tex_multiplier;
	out_TexCoord.y += tex_offset / 3;
	gl_Position = projectionMatrix * modelViewMatrix * v;
}