define(function(require){
    var Timer = require("Timer");

    var width = 200;
    var height = 31;
    var image =
        "110000011110000011111111111000011111111" +
        "000011000011111111110000111111111111000" +
        "011100000000011000011111111111111111000" +
        "011111111111100000111111111110000111111" +
        "111000011000011111111100001100000000000" +
        "000111100000111100000111111111110000111" +
        "111100000110000011111111100001111111111" +
        "110000111000000000110000011111111111111" +
        "100000111111111111000001111111111100001" +
        "111111100000110000011111111000011000000" +
        "000000001111000001111000000111111111100" +
        "001111110000001100000001111111000011111" +
        "111111100001110000000001100000011111111" +
        "111111000001111111111110000001111111111" +
        "000011111110000001100000001111110000110" +
        "000000000000011110000011111000001111111" +
        "111000011111000000011000000001111110000" +
        "111111111111000011100000000011000000011" +
        "111111111110000111111111111110000011111" +
        "111110000111111000000011000000001111100" +
        "001100000000000000111100000111111000001" +
        "111111110000111100000000110000000001111" +
        "100001111111111110000111000000000110000" +
        "000011111111111100001111111111111110000" +
        "011111111100001111100000000110000000001" +
        "111000011000000000000001111000001111110" +
        "000011111111100001110000001111111100000" +
        "011111000011111111111100001110000111111" +
        "111100000011111111110000011011111111111" +
        "100000111111111000011110000001111111100" +
        "000011110000111111111111111111110000011" +
        "111110000011111111000011100000111111111" +
        "100000111110000111111111111000011100001" +
        "111111111100000111111111100000110111111" +
        "111111100000111111110000111100000111111" +
        "111100000111100001111111111111111111100" +
        "000111101100000111111110000111000001111" +
        "111111100001111100001111111111110000111" +
        "000011111111111100001111111111000011101" +
        "111111111011000001111111100001111000001" +
        "111111111100001111000011111111111111111" +
        "111000001111001100000111111100001110000" +
        "011111111111000011111000011111111111100" +
        "001110000111111111111000011111111110000" +
        "111011111111110011000001111111000011110" +
        "000011111111111000011110000111111111111" +
        "111111110000011110011000000111111000011" +
        "100000111111111110000111110000111111111" +
        "111000011100001111111111110000111111111" +
        "000001100011111111100110000001111110000" +
        "111100000111111111111111111100001111111" +
        "111111111111100000111100011000001111110" +
        "000111000001111111111111111111100001111" +
        "111111110000111000011111111111100001111" +
        "111110000011000111111111000110000011111" +
        "100001111000001111111111111111111000011" +
        "111111111111111111000001111000110000001" +
        "111100001110000011111111111111111111000" +
        "011111111111100001110000111111111110000" +
        "011111111100001110001111111110001100000" +
        "011111000011110000011111111111111111110" +
        "000111111111111111111110000011110000110" +
        "000011111000011100000011111111111111111" +
        "110000111111111111000011100001111111111" +
        "000000111111110000011100011111111100001" +
        "100000111110000111100000111111111111111" +
        "111100001111111111111111111100000111100" +
        "001100000011110000111100000000110000111" +
        "111111100001111111111110000111000000000" +
        "110000000011111111100000110000011111111" +
        "000011000000111100001111000001111111111" +
        "111111111000011000000111111111111000001" +
        "111000011100000111100001111100000001100" +
        "000111111111000011111111111100001110000" +
        "000001100000001111111111000001100000111" +
        "111110000111000001111000011110000011111" +
        "111111111111110000110000001111111111110" +
        "000011110000111000000111000011111100000" +
        "011000000111111110000111111111111000011" +
        "100000000011000000111111111110000111100" +
        "001111111100001110000001110000111100000" +
        "111111111111111111100001100000011111111" +
        "111100000111100001111000001110000111111" +
        "100000110000000111111100001111111111110" +
        "000111000000000110000011111111111000001" +
        "111000011111111000011110000011100001111" +
        "000001111111111111111111000011000000111" +
        "111111111000001111000011110000001100001" +
        "111111100001100000000111111000011111111" +
        "111100001110000000001100001111111111110" +
        "000011110000011111110000111100000011000" +
        "011110000011111111111111111110000110000" +
        "001111111111110000011110000111110000011" +
        "000011111111111111111000000111110000111" +
        "111111111000011100001111111111111111111" +
        "111100000111100000111111100001111100000" +
        "110000111100000111111111111111111100001" +
        "111111111111111111100000111100001111100" +
        "000011000111111111111111111000001111100" +
        "001111111111110000111000011111111111111" +
        "111111111000011111100001111111000011111" +
        "000000110001111000001111111111111111111" +
        "000011111111111111111111000001111000011" +
        "111100000111001111111111111111111000011" +
        "111000011111111111100001110000111111100" +
        "000111111111100000111111000011111110000" +
        "111111000001110011110000011111111111111" +
        "111110000111111111111111111110000011110" +
        "000111111100000110011100000111111111110" +
        "000111110000111111111111000011100001111" +
        "111100001111111111000001100000000011111" +
        "100001111111000001100111100000111111111" +
        "111111111100001111111111111111111100000" +
        "111100001111111000001110111000001111111" +
        "111100001111100001111111111110000111000" +
        "011111111000001111111110000111000000000" +
        "111111000011111110000011101111000001111" +
        "111111100001111000011111111111111111111" +
        "000001111000011111111000001101110000011" +
        "111111111000011111000011111111111100001" +
        "110000111111111000011111111100001110000" +
        "000001111110000111111110000011011110000" +
        "011111111111000011110000111111111111111" +
        "111110000011110000111111110000001111100" +
        "000111111111100000111110000011111111110" +
        "000011100001111111110000011111110000011" +
        "100000000011111100001111111100000011111" +
        "100000111111111100000111100001111111111" +
        "111111111100000111100001111111110000011" +
        "111000000111111110000001111100000011111" +
        "111000000111000011111111100000111111100" +
        "000110000000000011111000011111111100000" +
        "111111000000111111110000001111000011111" +
        "111111111111111000001111000011111111100" +
        "000011110000000001100000000011111100000" +
        "000110000000011110000111111111100001111" +
        "111000011111111100000111110000111111111" +
        "000000111111000000001100000000011110000" +
        "110000000000000011110000011110000111111" +
        "111100000111111000000011000000001111111" +
        "100000001100000001111100001111111111000" +
        "001111110000111111111100001111100001111" +
        "111111000001111111000000011000000001111" +
        "100001100000000000000111100000111100001" +
        "111111111000000111111000000110000000111" +
        "111111100000011000000111111000011111111" +
        "111000011111000001111111111000011111000" +
        "011111111110000001111111000000110000000" +
        "111111000011000000000000001111000001111" +
        "000011111111111000001111111000001100000" +
        "111111111111100000110000011111110000111" +
        "111111110000011110000011111111110000011" +
        "110000111111111110000011111111000001100" +
        "000111111110000110000000000000011110000" +
        "011110000111111111110000011111111000011" +
        "000011111111111111100001100001111111100" +
        "001111111111100000111100001111111111100" +
        "000111100001111111111100000111111111000" +
        "01100001111111110000110000000000000011";

    var x = 0;
    var y = 0;

    var geometry = _.reduce(image, function(geometry, pixel){
        x++;
        if(x == width){
            x = 0;
            y--;
        }
        if(pixel == "0") {
            geometry.vertices.push(
                new THREE.Vector3(
                    (x - width / 2) / 10,
                    (y + height / 2) / 10,
                    0
                )
            );
            geometry.colors.push(new THREE.Color(1,1,1))
        }

        return geometry;
    }, new THREE.Geometry());

    var particleSystemMaterial = new THREE.ParticleSystemMaterial({
        map: THREE.ImageUtils.loadTexture("images/star.png"),
        size: 0.9,
        transparent: true,
        blending: THREE.AdditiveBlending,
        vertexColors: true
    });

    var decayLimit = 0;
    var timer = new Timer();
    return {
        system: new THREE.ParticleSystem(geometry, particleSystemMaterial),
        render: function(time){
            /* Time coefficient to keep things moving in same time even when framedropping */
            var timeCoef = timer.getPassed(time) * 60;

            _.each(geometry.vertices, function(vertex, idx){
                if(idx > decayLimit) return;

                geometry.vertices[idx].z -= 0.1 * timeCoef;
                geometry.vertices[idx].x += (((width - idx) % width) / width - 0.5) * 0.1 * timeCoef;
                geometry.vertices[idx].y += (((width - idx) % width) / width - 0.5) * 0.03 * timeCoef;

                geometry.colors[idx].r -= 0.008 * timeCoef;
                geometry.colors[idx].g -= 0.008 * timeCoef;
                geometry.colors[idx].b -= 0.008 * timeCoef;

            });

            geometry.verticesNeedUpdate = true;
            geometry.colorsNeedUpdate = true;

            decayLimit+= 20 * timeCoef;
        }
    };
});