/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.expressions;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.expressions.ExprTreeBuilder;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;

public class VariableReference
extends ExprNode {
    private String name;

    public VariableReference(String string, DebugInfo debugInfo) {
        super(debugInfo);
        this.name = string;
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) throws AsmException {
        Value value = (Value)evaluationState.getCurrentScope().getSymbols().get(this.name);
        if (value == null) {
            throw new AsmError("Unknown symbol '" + this.name + "'", this.debug);
        }
        if (value.isInvalidOrInvalidContent()) {
            if (evaluationState.failOnInvalidValue()) {
                throw new AsmError("Cant resolve invalid value '" + this.name + "'", this.debug);
            }
            evaluationState.setInvalidSideEffectsDuringFunctionEvaluation();
        }
        return value;
    }

    public String toString() {
        return "VarReference(" + this.name + ")";
    }

    @Override
    public ExprTreeBuilder toNodeTreeString(ExprTreeBuilder exprTreeBuilder) {
        exprTreeBuilder.addNode("VarRef", this.name, new ExprNode[0]);
        return exprTreeBuilder;
    }
}

