/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmandfunctionmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.directives.Directive;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;

public class EvalDirective
extends Directive {
    private ExprNode expr;
    private boolean evalFinished = false;

    public EvalDirective(ExprNode exprNode, DebugInfo debugInfo) {
        super(debugInfo);
        this.expr = exprNode;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        evaluationState.clearFunctionSideOutput();
        this.expr.evaluate(evaluationState);
        boolean bl = this.evalFinished = !evaluationState.getErrorDuringFunctionEvaluation();
        if (evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput());
    }

    @Override
    public boolean isFinished() {
        return this.evalFinished;
    }

    @Override
    public void functionParse(EvaluationState evaluationState) {
        this.expr.evaluate(evaluationState);
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.addNode("Eval", this.debug, this.expr);
        return nodeTreeBuilder;
    }
}

