nolist

VRAMLINES_C000 equ &0100
VRAMLINES_8000 equ &0200

TILES_LINE1 equ &0300

			; 0C00 - &13FF (outside Y height 8)
VBUFFER1 equ &2020	; left - right 32 (or 64) - outside X (&1400-&141F = &1460-&147F)
;VBUFFER2 equ &14A0	; left - right 32 (or 64) - outside X (&1480-&149F = &14E0-&14FF) not really used
			; 3800 - &3FFF (outside Y height 8)

HBUFFER equ &6000	; heightmap
HSTORE equ &1000 	; if not then over octaves at &4000

UNROLL_SPACE equ &0500

VWIDTH equ 48
VHEIGHT equ 32

; ===== CPC Graphics functions =====

render_unroll_start:
        ld e,(hl):ld (hl),0:inc l:ld a,(de):inc d:ld (bc),a:inc c:ld a,(de):exx:ld (bc),a:inc c:exx
        ld e,(hl):ld (hl),0:inc l:ld a,(de):dec d:exx:ld (bc),a:inc c:exx:ld a,(de):ld (bc),a:inc c

render_unroll_end:
render_unroll_jump_start:
	jp render_unroll_back
render_unroll_jump_end:

init_render_unroll:
	ld de,UNROLL_SPACE

	ld a,VWIDTH/2

	init_render_unroll_loop:
		ld hl,render_unroll_start
		ld bc,render_unroll_end - render_unroll_start
		ldir
	dec a
	jr nz,init_render_unroll_loop

	ld hl,render_unroll_jump_start
	ld bc,render_unroll_jump_end - render_unroll_jump_start
	ldir
ret

render_tilebuffer_to_screen:
; de = tile_buffer		(e.g. TILES_LINE1)
; hl = vram_lines		(e.g. VRAMLINES_C000)

    ;ld (sp_save),sp

;    ld sp,hl
	push hl:pop ix
    ld hl,VBUFFER1

    ld iy,VHEIGHT;
    tile_lines48:
	ld c,(ix):inc ix:ld b,(ix):inc ix:
	exx:ld c,(ix):inc ix:ld b,(ix):inc ix:exx

	jp UNROLL_SPACE
	render_unroll_back:

	ld a,l

	sub VWIDTH
	ld l,a:inc h

    dec iyl
    jp nz,tile_lines48

    ;ld sp,(sp_save)
ret

;init_vram_lines_left:
;;	ld de,&C000+16: ld hl,VRAMLINES_C000: call generate_vram64
;;	ld de,&8000+16: ld hl,VRAMLINES_8000: call generate_vram64
;;ret

;init_vram_lines_right:
;;	ld de,&C000+32: ld hl,VRAMLINES_C000: call generate_vram64
;;	ld de,&8000+32: ld hl,VRAMLINES_8000: call generate_vram64
;ret

generate_vram64:
	ld b,25
	rows25:
		ld c,4
		lines8:
			ld (hl),e:inc hl:ld (hl),d:inc hl
			ld a,d:add 8:add 8:ld d,a
		dec c
		jr nz,lines8
	ld a,d:sub 64:ld d,a
	ld a,e:add 64:jr nc,no256
	inc d
	no256:
	ld e,a
	dec b
	jr nz,rows25
ret

;tile_copy_routine:
;ret

;init_tile_lines:
;;ld hl,chars:ld de,TILES_LINE1
;call tile_copy_routine
;ret

init_vram:
;	call init_vram_lines_left
;;	ld de,&C000+16: ld hl,VRAMLINES_C000: call generate_vram64
;;	ld de,&8000+16: ld hl,VRAMLINES_8000: call generate_vram64

	;call init_tile_lines
;;	ld hl,chars:ld de,TILES_LINE1
;;	call tile_copy_routine

;;	ld de,pal1: ;ld a,4: call load_palette
;;	xor a: call change_border_color
;;ret

;select_page_8000:
;;ld bc,&bc0c:out (c),c
;;ld bc,&bd20:out (c),c
;ret

;select_page_C000:
;;ld bc,&bc0c:out (c),c
;;ld bc,&bd30:out (c),c
;ret

; ---- Change Width ----
; E = width (in bytes)

;change_width:
;;	ld bc,&bc01:out(c),c
;;	inc b:ld c,&20:out (c),c

;;	ld bc,&bc02:out(c),c:inc b:ld c,&2a:out(c),c

;;	ld bc,&bc06:out (c),c
;;	inc b:ld c,20:out (c),c
;ret

; ---- Load Palette ----
; DE = paltable
; A = number of colors used
; Changes BC, HL

load_palette:
ld a,4
ld (noc+1),a
ld bc,&7f00

palloop:
push de:push bc
out (c),c
ld a,(de):;ld d,0:;ld e,a
;ld hl,palcodes:;add hl,de
;ld c,(hl):;out (c),c
out (c),a
pop bc:pop de
inc bc:inc de

ld a,c
noc:
cp 4
jr nz,palloop
ret

; ---- Change Border Color ----
; A = color

;;change_border_color:
;	ld hl,palcodes
;;	add a:ld d,0:ld e,a
;	add hl,de
;	ld a,(hl)
;;	ld bc,&7f10:out (c),c:out (c),a
;ret

;Hardware colour pallete precs
; ----------------------------

palcodes:
;db &54,&44,&55,&5c
;db &58,&5d,&4c,&45
;db &4d,&56,&46,&57
;db &5e,&40,&5f,&4e
;db &47,&4f,&52,&42
;db &53,&5a,&59,&5b
;db &4a,&43,&4b
