nolist

VOX_WIDTH equ 96
VOX_HEIGHT equ 24

OCTAVES_NUM equ 8
OCTAVE_SIZE equ 32
OCTAVE_SIZE_MINUS1 equ 31
OCTAVE_SIZE_X2 equ 64
OCTAVE_SIZE_X3 equ 96
OCTAVE_SIZE_FULL equ 256

init_octave:
	ld hl,(where):ex de,hl
	ld c,0
	plas_y:
		push de
		ld b,OCTAVE_SIZE
		plas_x:
			ld hl,SINES1
			ld l,b:ld a,(hl)
			inc h:ld l,c:add a,(hl)

			ld (de),a:inc e
		dec b
		jr nz,plas_x
		pop de:inc d
	inc c:ld a,c:cp OCTAVE_SIZE
	jr nz,plas_y
ret

add_octaves:
	ld hl,octaves
	exx
	; it was VBUFFER1, but now HBUFFER to write to heightmap
	ld de,HBUFFER
	;ld de,VBUFFER1
	exx	
	ld c,0
	aoct_y:
		ld b,OCTAVE_SIZE_FULL
		aoct_x:
			ld hl,octaves
;;coord0:			ld a,0:add b:and OCTAVE_SIZE_MINUS1:ld e,a
;;coord1:			ld a,0:add c:and OCTAVE_SIZE_MINUS1:ld d,a:add hl,de
			ex af,af':ld a,(hl):ex af,af'

			ld hl,octaves
coord2:			ld a,24:add b:and OCTAVE_SIZE_MINUS1:add OCTAVE_SIZE:ld e,a
			ld d,c
;;coord3:			ld a,0:add c:and OCTAVE_SIZE_MINUS1:ld d,a
			add hl,de
			ex af,af':add a,(hl):ex af,af'

			ld hl,octaves
coord4:			ld a,248:add b:and OCTAVE_SIZE_MINUS1:add OCTAVE_SIZE_X2:ld e,a
;;coord5:			ld a,0:add c:and OCTAVE_SIZE_MINUS1:ld d,a
;			ld d,c
			add hl,de
			ex af,af':add a,(hl):ex af,af'

			ld hl,octaves
coord6:			ld a,4:add b:and OCTAVE_SIZE_MINUS1:add OCTAVE_SIZE_X3:ld e,a
coord7:			ld a,252:add c:and OCTAVE_SIZE_MINUS1:ld d,a:add hl,de
			ex af,af':add a,(hl)

			exx:ld (de),a:inc e:exx

		dec b
		jr nz,aoct_x
		exx:inc d:;ld e,&20:ld e,0:exx
	inc c:ld a,c:cp OCTAVE_SIZE
	jr nz,aoct_y
ret

init_sines:
	ld a,(sinums):ld b,a:ld a,(sinums+1):ld c,a
	ld hl,SINES1: call gensine

	ld a,(sinums+2):ld b,a:ld a,(sinums+3):ld c,a
	ld hl,SINES2: call gensine
ret

sinums:
;	db 0,0,0,0
;;sinums_orig:
	db 4,2,4,2
where:
	dw octaves

inc_sinums:
	ld hl,sinums
	ld a,(hl):sla a:ld (hl),a:inc hl
	inc (hl):inc hl
	ld a,(hl):sla a:ld (hl),a:inc hl
	inc (hl):inc hl
ret

inc_octave_place:
	ld hl,(where)
	ld de,OCTAVE_SIZE
	add hl,de
	ld (where),hl
ret

init_octaves:
;;ld hl,sinums_orig:ld de,sinums:ld bc,4:ldir

ld iyl,OCTAVES_NUM
more_octaves:
	call init_sines
	call inc_sinums
	call init_octave
	call inc_octave_place
	dec iyl
jr nz,more_octaves

ret

move_camera:
	ld h,basesine / 256:ld a,(nframe):add a,a:add a,a:ld l,a
	ld a,(hl):srl a:srl a:srl a:ld (angle),a
	
;;	ld a,(angle):inc a:inc a:ld (angle),a
	ld hl,(positionX):ld de,384: add hl,de:ld (positionX),hl
;;	ld hl,(positionY):ld de,512: add hl,de:ld (positionY),hl
ret


voxel_effect:

;ld ix,VBUFFER1 + 32*256
ld bc,HSTORE	; sampled heights store
ld iyh, basesine / 256
ld a,(angle):ld iyl,a
exx:ld bc,basesine:exx

ld ixh,VOX_WIDTH
vxLoopX:
	ld hl,0:;ld hl,(positionY)
	ld e,(iy + 64):ld d,0
	exx:ld hl,(positionX):ld e,(iy):ld d,0:exx
	inc iyl

	ld ixl,VOX_HEIGHT
	vxLoopY:
nop1:
	add hl,de
	add hl,de
	ld a,h:and 31:; X maybe 0 to 255, Y 0 to 31
	add a,96	; to &6000 HBUFFER

	exx
nop2:
	add hl,de
	add hl,de
	ld c,h:ld b,a
	ld a,(bc)
	exx
		ld (bc),a
		inc bc
	dec ixl
	jr nz,vxLoopY
dec ixh
jr nz,vxLoopX

ret




voxel_effect_render:

ld hl,VBUFFER1 + 31*256 + 32
ld de,HSTORE

ld ixh,VOX_WIDTH
vxLoopXr:
	push hl
	;ld iy,baseY
	ld iyl,0
	ld ixl,VOX_HEIGHT
	vxLoopYr:
		ld a,(maxHeight):ld b,a
		ld a,(de):ld c,a:srl a:srl a:add a,iyl:;add a,(iy):sub a,32
		jr nc,noUnder
		xor a,a
noUnder:
		inc de

		sub b
		jr c,noColumnDraw
		jr z,noColumnDraw

		add b
		ld (maxHeight),a
		sub b
		
columnDrawLoop:
		ld (hl),c:dec h
		jr z,wtf
		dec a
		jr nz,columnDrawLoop
noColumnDraw:
	inc iyl

	dec ixl
	jr nz,vxLoopYr
wtf:
	xor a,a:ld (maxHeight),a
	pop hl
	inc l
dec ixh
jr nz,vxLoopXr

ret

;list
;baseY2:
;ds 32,0
;nolist
;db 0,0,0,0,1,1,1,2,2,3,3,4,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23


