import checked_gl
from datatypes import Float
from fw_3d import Shader, VboStrip, Picture, Rtt, quad, Mesh
import matutil as mat
import gl
import gl2
import time
import sys
import math
import numpy as np

class Demo(object):
	def __init__(self, fw, argv):
		print "Initing"
		initstart = time.time()
		self.size = (1, 1)
		self.startcheat = 0.0
		for i, a in enumerate(argv):
			if a == "--start":
				self.startcheat = float(argv[i + 1])
				break
		self.effectstart = 0.0
		self.fw = fw
		self._get_gl(fw.gl(), argv)
		self._load_resources()
		self._setup_gl()
		print "Inited in %.2f seconds" % (time.time() - initstart)
		self.frames = 0
		self.starttime = time.time()
		self.last_fps = self.starttime

	def _load_resources(self):
		self.shader = Shader.from_files(self.gl, "trivial_pos.vert", "test.frag")
		self.postsh = Shader.from_files(self.gl, "trivial_pos.vert", "post.frag")
		self.blitshader = Shader.from_files(self.gl, "blit.vert", "blit.frag", ("position", "uvcoord"))
		self.modelshader = Shader.from_files(self.gl, "model.vert", "model.frag", ("position", "normal"))
		tris = (-1.0, -1.0, 1.0, # top left
				-1.0,  1.0, 1.0,
				 1.0,  1.0, 1.0,

				-1.0, -1.0, 1.0, # bottom right
				 1.0,  1.0, 1.0,
				 1.0, -1.0, 1.0
				 )
		self.quad = VboStrip(self.gl, tris)
		self._load_textures(["pblogo", "raspi", "deadly_fumes", "thats_all_folks", "bros", "present", "copyright", "codercolor", "thats_all_folks"])
		self.rtt = None
		self.bong = Mesh.load_wavefront(self.gl, open("models/bong.obj"))
		self.bonged = False

	def _load_textures(self, texs):
		self.texs = {}
		for i in texs:
			self.texs[i] = Picture(self.gl, i)

	def depthoff(self):
		self.gl.glDisable(gl.GL_DEPTH_TEST)

	def depthon(self):
		self.gl.glEnable(gl.GL_DEPTH_TEST)

	def _setup_gl(self):
		self.gl.glClearColor(Float(0.4), Float(0.1), Float(0.1), Float(1.0))
		self.gl.glClearDepthf(Float(1.0))
		self.gl.glDepthMask(gl2.GL_TRUE)
		self.gl.glDepthFunc(gl.GL_LEQUAL)
		self.gl.glDepthRangef(Float(0.0), Float(1.0))

		self.gl.glEnable(gl.GL_BLEND)
		self.gl.glBlendFunc(gl2.GL_ONE_MINUS_SRC_ALPHA, gl2.GL_ONE_MINUS_SRC_ALPHA)
		self.gl.glBlendFunc(gl2.GL_SRC_ALPHA, gl2.GL_ONE_MINUS_SRC_ALPHA)

	def _get_gl(self, gl_, argv):
		# this includes glgeterrors in the calls
		#self.gl = checked_gl.TimedCalls(checked_gl.CheckedGl(fw.gl()))
		# this times glgeterrors separately
		#self.gl = checked_gl.CheckedGl(checked_gl.TimedCalls(fw.gl()))
		# no checking/diagnosis
		#self.gl = fw.gl()

		self.gl = gl_
		for a in argv:
			if a == "--time":
				self.gl = checked_gl.TimedCalls(self.gl)
			elif a == "--check":
				self.gl = checked_gl.CheckedGl(self.gl)

	def reshape(self, w, h):
		self.rtt = Rtt(self.gl, (w, h))
		self.resolution = (w, h)
		print "reshaped to", w, h

	def vport(self):
		self.gl.glViewport(0, 0, self.resolution[0], self.resolution[1])

	def diagnostics(self):
		self.frames += 1
		now = time.time()
		secs = now - self.last_fps
		if secs > 1:
			frames = self.frames
			self.frames = 0
			fps = frames / secs
			print "%s frames in %s seconds = %.3f fps" % (frames, secs, fps)
			self.last_fps = now

	def seconds(self):
		return time.time() - self.starttime + self.startcheat

	def effectseconds(self):
		return self.seconds() - self.effectstart

	def clear(self):
		self.gl.glClear(gl.GL_COLOR_BUFFER_BIT | gl.GL_DEPTH_BUFFER_BIT)

	def render(self):
		#print "render"
		self.clear()

		s = self.seconds()
		if s < 15:
			self.effectstart = 0
			self.introscreen(s)
		elif s < 30:
			self.effectstart = 15
			if not self.bonged:
				self.bong._setup()
				self.bonged = True
			#self.rttrender(self.rtt, lambda: self.bongscreen(s - 15))
			#self.postprocess(self.rtt)
			self.bongscreen(s - 15)
		else:
			self.effectstart = 30
			self.outroscreen(s - 30)

		self.fw.swap()
		self.diagnostics()

	def camera(self, campos, orientation=np.eye(3)):
		position = np.matrix([campos]).T

		pos = orientation.T * position
		base = np.mat([0, 0, 0, 1])
		m = np.bmat([[orientation, -pos], [base]])
		return m

	def perspective(self, fov, near, far):
		f = 1.0 / math.tan(fov / 2.0 * 3.14159 / 180)
		divi = 1.0 / (near - far)
		return np.matrix([
			[f,   0.0,                 0.0,                   0.0],
			[0.0,  f,                  0.0,                   0.0],
			[0.0, 0.0, (near + far) * divi, 2 * near * far * divi],
			[0.0, 0.0,                -1.0,                   0.0]
		])

	def rttrender(self, rtt, rendfn):
		rtt.attach()
		self._setup_gl()
		rendfn()
		rtt.detach()
		self.vport()
	def postprocess(self, rtt):
		self.clear()
		self.depthoff()
		self.postsh.use()
		self.postsh.texture("tex", 0, rtt.diffusetex)
		self.quad.draw()

	def introscreen(self, secs):
		self.clear()
		self.depthoff()
		self.shader.use()
		self.shader.uniform("seconds", self.effectseconds())
		self.shader.texture("logotex", 0, self.texs["pblogo"])
		self.shader.texture("raspitex", 1, self.texs["raspi"])
		self.quad.draw()

		if secs < 12:
			self.fadein("bros", -0.5, 0.5, secs, 2, 4)
			self.fadein("present", -0.5, 0.3, secs, 5, 6)
			self.fadein("copyright", -0.5, -0.5, secs, 6, 7)
		if secs > 7:
			self.fadein("pblogo", -0.1, 0.1, secs, 7, 8)
		if secs > 10:
			self.zoomin("raspi", 0.0, 0.0, secs, 10, 11)
		if secs >= 12:
			if secs < 13:
				self.fadein("bros", -0.5, 0.5, secs, 13, 12)
				self.fadein("present", -0.5, 0.3, secs, 13, 12)
				self.fadein("copyright", -0.5, -0.5, secs, 13, 12)

			self.fadein("deadly_fumes", -0.5, 0.5, secs, 12, 12.5)
			self.fadein("codercolor", -0.5, -0.5, secs, 12.5, 13)

	def bongscreen(self, secs):
		self.clear()
		self.depthon()
		for i in range(min(int(secs/2), 3)):
			self.rendermesh(self.bong, [i-1, 0, 3])
	
	def rendermesh(self, mesh, cam):
		self.modelshader.use()
		self.modelshader.uniform("seconds", self.effectseconds())
		projection = self.perspective(60.0, 0.01, 100.0)
		worldtocam = self.camera(cam)
		worldtoclip = projection * worldtocam
		objtoworld = mat.rotx(self.effectseconds()) * mat.roty(self.effectseconds()*0.5) * mat.rotz(self.effectseconds()*0.2)
		self.modelshader.uniformmat("worldToClip", list(worldtoclip.T.flat))
		self.modelshader.uniformmat("worldToCam", list(worldtocam.T.flat))
		self.modelshader.uniformmat("objToWorld", list(objtoworld.T.flat))
		mesh.render()

	def outroscreen(self, secs):
		self.clear()
		self.depthoff()
		self.shader.use()
		self.shader.uniform("seconds", self.effectseconds())
		self.shader.texture("logotex", 0, self.texs["pblogo"])
		self.shader.texture("raspitex", 1, self.texs["raspi"])
		self.quad.draw()

		self.fadein("bros", -0.5, 0.5, secs, 0, 1)
		self.fadein("thats_all_folks", -0.5, -0.8, secs, 0.5, 1.5)

	def zoomin(self, texname, xm, ym, curtime, starttime, endtime):
		tex = self.texs[texname]
		fade = min(1.0, self.mix(curtime, starttime, endtime))
		halfx = 0.5 * tex.size[0] / float(self.resolution[0])
		halfy = 0.5 * tex.size[1] / float(self.resolution[1])
		x0 = xm - fade * halfx
		y0 = ym - fade * halfy
		x1 = xm + fade * halfx
		y1 = ym + fade * halfy
		self.blittex(tex, x0, y0, x1, y1)

	def fadein(self, texname, x0, y0, curtime, starttime, endtime):
		tex = self.texs[texname]
		fade = self.mix(curtime, starttime, endtime)
		x1 = x0 + tex.size[0] / float(self.resolution[0])
		y1 = y0 + tex.size[1] / float(self.resolution[1])
		self.blittex(tex, x0, y0, x1, y1, fade)

	def mix(self, t, a, b):
		return (t - a) / (b - a)

	def blitfull(self, tex):
		self.blittex(tex, -1, -1, 1, 1)

	def blittex(self, tex, x0, y0, x1, y1, fade=1.0):
		self.blitshader.use()
		self.blitshader.texture("tex", 0, tex)
		self.blitshader.uniform("fadein", fade)
		q = quad(self.gl, x0, y0, x1, y1)
		q.draw()

	def stats(self):
		print "Total runtime: %.3f s" % self.seconds()
		try:
			self.gl.dump()
		except AttributeError:
			pass

def main():
	if len(sys.argv) != 1 and sys.argv[1] == "--es":
		import fw_opengles as fw
		argv = sys.argv[2:]
	else:
		import fw_opengl as fw
		argv = sys.argv[1:]
	fw.init("Persdemo", 1280, 720)
	try:
		demo = Demo(fw, argv)
		fw.run(demo)
	except KeyboardInterrupt:
		demo.stats()

if __name__ == "__main__":
	main()
