import numpy as np
from numpy import sin, cos


def rotx(ang):
	return np.matrix([
			(1.0,      0.0,       0.0, 0.0),
			(0.0, cos(ang), -sin(ang), 0.0),
			(0.0, sin(ang),  cos(ang), 0.0),
			(0.0,      0.0,       0.0, 1.0),
	])

def roty(ang):
	return np.matrix([
			( cos(ang), 0.0, sin(ang), 0.0),
			(      0.0, 1.0,      0.0, 0.0),
			(-sin(ang), 0.0, cos(ang), 0.0),
			(      0.0, 0.0,      0.0, 1.0),
	])

def rotz(ang):
	return np.matrix([
			( cos(ang), sin(ang), 0.0, 0.0),
			(-sin(ang), cos(ang), 0.0, 0.0),
			(      0.0,      0.0, 1.0, 0.0),
			(      0.0,      0.0, 0.0, 1.0),
	])
