#include "uniforms.glsl"
#include "utils.glsl"
#line 3 1

#ifdef VERT_SHADER
#line 1 2
#include "geometry_vertex_io.glsl"
#line 9 1

out vec3 worldPosition;

void process() 
{
	mat4 newViewMatrix = viewMatrix;
	viewMatrix[0][3] = 0.0;
	viewMatrix[1][3] = 0.0;
	viewMatrix[2][3] = 0.0;
	
	mat4 newModelMatrix = modelMatrix;
	newModelMatrix[0][3] = 0.0;
	newModelMatrix[1][3] = 0.0;
	newModelMatrix[2][3] = 0.0;
	
	worldPosition = (newModelMatrix*in_Position).xyz;
	ex_Position = (newViewMatrix*newModelMatrix)*in_Position;
	gl_Position = (projectionMatrix*newViewMatrix*newModelMatrix)*in_Position;
}

#define PROCESSING_FUNCTION process
#include "geometry_base_vertex.glsl"

#endif


#ifdef FRAG_SHADER
#include "geometry_base_fragment_io.glsl"
#line 36
in vec3 worldPosition;

// this replaces geometry_base_fragment_main
void main()
{
	vec4 sampld = texture(tex, ex_UV.xy);
	vec3 col = sampld.rgb;

	if (sampld.a <= ALPHA_TEST_THRESHOLD) {
		discard;
	}
	
	vec3 pos = normalize(worldPosition.xyz);
	col.rgb = hsv2rgb(vec3(
		abs((pos.y - 1.0 + 3.1)) * 0.2  , 
		clamp(1.0-pos.x, 0.0, 1.0) *0.1, 
		min(1.0, abs(1.0-pos.y - 0.3)*0.4 + (sin(pos.z*4.0 + p_beat*0.25) * sin(pos.x))*0.1)*0.5
	));
	
	vec3 red = hsv2rgb(vec3(0.0, 0.95, 0.4));
	col = mix(col.rgb, red.rgb, max(0.0, pos.x - pos.y));
	
	out_Color = vec4(col, 1.0);
	
	out_Position = ex_Position.xyz;
	out_Normal.xyz = compressv3(ex_Normal.xyz);
	out_Material = vec4(texture(emitMap, ex_UV.xy).r, 0.0, 0.0, 0.0);
}

#endif