#include "inout.hlsl"

cbuffer LightBuffer
{
    float4 LIGHT_Color;
    float3 LIGHT_Direction;
    float  LIGHT_Padding;
};

float4 Instance_PS(PIT_INSTANCE input) : SV_TARGET
{
	float3	lightDir;
    float	lightStrength;
	float4  litColor;
    float4	color;

	lightDir = -LIGHT_Direction;

    // Calculate the amount of light on this pixel.
    lightStrength = saturate(dot(input.normal, lightDir));

	if (lightStrength > 0.0f)
	{
		litColor = (LIGHT_Color * lightStrength);
		litColor = saturate(litColor);
	}

//	litColor += float4(0.2f, 0.2f, 0.2f, 0.0f);

    // Determine the final amount of diffuse color based on the diffuse color combined with the light intensity.
    color = saturate(input.color * litColor);

	return color;
}
