struct VIT_BB
{
	float4 position	: POSITION;
	float2 size		: SIZE;
	float4 color	: COLOR;
};
struct GIT_BB
{
	float4 position	: POSITION;
	float2 size		: SIZE;
	float4 color	: COLOR;
};
struct PIT_BB
{
	float4 position	: SV_POSITION;
	float4 color	: COLOR;
	float2 tex		: TEXCOORD0;
};

struct VIT_C4E
{
	float4 position	: POSITION;
	float3 normal	: NORMAL;
	float4 color	: COLOR;
	float2 tex		: TEXCOORD0;
	float3 tangent	: TANGENT;
	float3 binormal	: BINORMAL;
};
struct PIT_C4E
{
	float4 position				: SV_POSITION;
	float3 normal				: NORMAL;
	float4 color				: COLOR;
	float2 tex					: TEXCOORD0;
	float2 texEnv				: TEXCOORD1;
	float3 tangent				: TANGENT;
	float3 binormal				: BINORMAL;

	float3 viewDirection		: TEXCOORD2;
	float4 lightViewPosition	: TEXCOORD3;
	float4 worldPosition		: TEXCOORD4;
};

struct VIT_DEPTH
{
  float4 position : POSITION;
};
struct PIT_DEPTH
{
  float4 position : SV_POSITION;
  float4 depthPosition : TEXTURE0;
};

struct VIT_FRACTAL
{
	float4 position	: POSITION;
	float4 color	: COLOR;
	float2 tex		: TEXCOORD0;
};
struct PIT_FRACTAL
{
	float4 position	: SV_POSITION;
	float4 color	: COLOR;
	float2 tex		: TEXCOORD0;
};

struct VIT_INSTANCE
{
	float4 position		: POSITION;
	float3 normal		: NORMAL;
	float4 color		: COLOR;
	float3 instancePos	: INSTANCEPOS;
	float4 instanceCol	: INSTANCECOL;
	float3 instanceScale: INSTANCESCALE;
};
struct PIT_INSTANCE
{
	float4 position	: SV_POSITION;
	float3 normal	: NORMAL;
	float4 color	: COLOR;
};

struct VIT_LINE
{
	float4 position	: POSITION;
	float4 color	: COLOR;
};
struct PIT_LINE
{
	float4 position	: SV_POSITION;
	float4 color	: COLOR;
};

struct VIT_PP
{
	float4 position : POSITION;
	float4 color	: COLOR;
	float2 tex		: TEXCOORD0;
};
struct PIT_PP
{
	float4 position : SV_POSITION;
	float4 color	: COLOR;
	float2 tex		: TEXCOORD0;
};
