#include "inout.hlsl"

cbuffer MatrixBufferC4E
{
	matrix worldMatrixC4E;
	matrix viewMatrixC4E;
	matrix projectionMatrixC4E;
	matrix lightViewMatrixC4E;
	matrix lightProjectionMatrixC4E;
};

cbuffer CameraBuffer
{
	float3	CAMERA_Position;
	float	CAMERA_Padding;
};

PIT_C4E c4e_VS(VIT_C4E input)
{
	PIT_C4E output;

	input.position.w = 1.0f;

	output.position = mul(input.position, worldMatrixC4E);
	output.position = mul(output.position, viewMatrixC4E);
	output.position = mul(output.position, projectionMatrixC4E);

	output.worldPosition = mul(input.position, worldMatrixC4E);

	output.lightViewPosition = mul(input.position, worldMatrixC4E);
	output.lightViewPosition = mul(output.lightViewPosition, lightViewMatrixC4E);
	output.lightViewPosition = mul(output.lightViewPosition, lightProjectionMatrixC4E);

	output.viewDirection = CAMERA_Position.xyz - output.worldPosition.xyz;
	output.viewDirection = normalize(output.viewDirection);

	output.normal = mul(input.normal, (float3x3)worldMatrixC4E);
	output.normal = normalize(output.normal);

	output.tangent = mul(input.tangent, (float3x3)worldMatrixC4E);
	output.tangent = normalize(output.tangent);

	output.binormal = mul(input.binormal, (float3x3)worldMatrixC4E);
	output.binormal = normalize(output.binormal);

	output.color	= input.color;
	output.tex		= input.tex;
	output.texEnv.x	= output.normal.x * -0.5f + 0.5f;
	output.texEnv.y = output.normal.y * -0.5f + 0.5f;

   	return output;
}