
layout(location = 0) in vec3 os_pos;
layout(location = 1) in vec3 os_norm;

uniform mat4 mvp;
uniform mat4 modelmat;
uniform mat4 modelviewmat;
uniform mat4 modelmatIT;
uniform vec4 ws_lightpos;
uniform vec4 time_s;

out vec3 ws_norm;
out vec3 ws_lightvec;
out vec3 ws_viewvec;

void main()
{
	float ofs = gl_VertexID + time_s.x;
	//TODO: maybe some better noiiise mkay? :p
	vec3 p = os_pos + os_norm *  0.5 * sin( ofs ) * sin( 2*ofs + 2 );

	gl_Position =  mvp * vec4( p, 1 );

	ws_norm = normalize( ( modelmatIT * vec4(os_norm,0) ).xyz );

	vec3 ws_pos = (modelmat * vec4(p,1)).xyz;
	ws_lightvec = ws_lightpos.xyz - ws_pos;

	ws_viewvec = (modelviewmat * vec4( p, 1 )).xyz;
}
