layout(location = 0, index = 0) out vec4 outcol0;

uniform vec4 fogdist;
uniform vec4 diffcol;
uniform sampler2D maintex;

in vec3 ws_norm;
in vec3 ws_view;
in vec3 ws_pos;
in vec2 texcoord;

void main()
{
	float light_ambient = (1.0f - dot(normalize(ws_norm), normalize(ws_view))) / 16;
	vec2 light_bake = pow(texture(maintex, texcoord).rg, vec2(2));
	light_bake *= diffcol.rg;
	float light = light_bake.r + light_bake.g + light_ambient;

	float fog = clamp(1 - length(ws_pos) / fogdist.x, 0, 1);
	 
	outcol0 = vec4(vec3(light) * fog,1);
}