

layout(location = 0, index = 0) out vec4 outcol0;

uniform sampler2D tex_over;
uniform sampler2D tex_mask;
uniform vec4 opasity;

in vec2 texcoord_nm;

void main()
{
	vec4 col_over = texture( tex_over, texcoord_nm );
	float mask = texture( tex_mask, texcoord_nm ).r;
	mask = 1.0f-smoothstep( 0.45f, 0.55f, mask ); //note: mask is distance

	float a = col_over.a * opasity.x * mask;
	outcol0 = vec4( col_over.rgb * a, a );
}
