

layout(location = 0, index = 0) out vec4 outcol;

uniform sampler2D tex0;

uniform vec4 parms;

in vec2 texcoord0_nm;

//note: hmmm, that's pretty cool... vary x to cut off part of image
// float brokentooth( float t ) {
//  float x = 0.5;
	// return abs( fract( t-1 ) - 0.5 )+x;
// }

// ====
// \/ [0;1]
float sawtooth( float t ) {
	return abs(mod(abs(t), 2.0f)-1.0f);
}

//note: [0;1]
float rand( vec2 n ) {
  return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}
//note: [-1;1]
float srand( vec2 n )
{
	return 2.0f * rand( n ) - 1.0f;
}

void main()
{
	float offset = parms.x;
	float blurdist_nm = parms.y;

	vec2 uv = texcoord0_nm;
	uv.y += offset;
	uv.y = 1-sawtooth( uv.y );

	uv.y += blurdist_nm * 0.05f * srand( texcoord0_nm );

	const int num_samples = 24; //TODO: depend on blurdist
	const float num_samples_f = float(num_samples);
	vec4 sample_col = vec4(0.0f);
	vec2 stepsiz = vec2(0,1)* blurdist_nm / num_samples_f;
	vec2 tc = uv - 0.5 * vec2(0,1)*blurdist_nm;
	for( int i=0; i<num_samples; ++i ) {
		sample_col += texture( tex0, tc );
		tc += stepsiz;
	}
	outcol = sample_col / num_samples_f;
}
