
layout(location = 0, index = 0) out vec4 outcol0;

uniform sampler2D tex0;
uniform vec4 tex0siz; //xy=size in pixels, zw = 1/xy
uniform vec4 time_s;

uniform vec4 dist;

in vec2 texcoord0_nm;

//note: [0;1]
float nrand( vec2 n ) {
  return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}
//note: [-1;1]
float srand( vec2 n ) {
	return -1 + 2*nrand(n);
}

void main(void)
{
	int num_samples_i = int( mix( 1, 35, pow(dist.x,0.25) ) );
	float num_samples = float(num_samples_i);
	float inv_num_samples = 1.0 / num_samples;

	float maxdist = 4.0 * dist.x;
	
	vec2 orgp = texcoord0_nm;
	vec2 ctrvec = vec2(0.5) - orgp;
    vec2 ps = orgp;
	vec2 pd = ps + maxdist * ctrvec;
	vec2 stepvec = ( maxdist * ctrvec ) * inv_num_samples;

	float rnd = srand( texcoord0_nm + fract(time_s.xx) );
	vec2 p = ps - 0.5 * num_samples * stepvec;
	p += 0.5 * stepvec * rnd;

	vec4 sum = vec4(0.0);
	float sumw = 0.0;
	for( int i=0; i < num_samples_i; i++ )
	{
		vec2 uv = p;
		vec4 sample = texture( tex0, uv );
		float w = 1.0;
		sum += w * sample;
		sumw += w;
		p += stepvec;
	}
	outcol0 = sum /= sumw;
}
