

layout(location = 0, index = 0) out vec4 outcol0;

uniform sampler2D tex_img;
uniform sampler2D tex_noise;
uniform vec4 opasity;
uniform vec4 time;

in vec2 texcoord0_nm;
in vec2 texcoord1;

//note: [0;1]
float rand_nm( vec2 n ) {
  return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}

void main()
{
	vec4 sample_col = texture( tex_img, texcoord0_nm );

	/*
	vec3 noise = vec3( rand_nm( texcoord0_nm + 0.13f * time.x * vec2(0,0.00027) )
					 , rand_nm( texcoord0_nm + 0.37f * time.x * vec2(0.0034,0) )
					 , rand_nm( texcoord0_nm + 0.49f * time.x * vec2(-0.001f) ) );
	noise = pow( noise, vec3(1.0f/2.2f) );
	noise *= 0.65f;
	/*/
	vec2 rnd = vec2( rand_nm( texcoord0_nm + 0.1f*mod(time.x,64) ), rand_nm( texcoord0_nm ) );

	// outcol0 = vec4( rnd.x, 0, 0, 1 );
	// return;

	vec2 ofs0 = rnd * (time.yz);
	vec2 ofs1 = rnd * (27.14 + time.yz);
	vec2 ofs2 = rnd * (0.133 + time.yz);

	vec3 noise_rgb = vec3(0);
	noise_rgb.rgb += texture( tex_noise, texcoord1 + ofs0 ).rgb;
	noise_rgb.rgb += texture( tex_noise, texcoord1 + ofs1 ).rgb;
	noise_rgb.rgb += texture( tex_noise, texcoord1 + ofs2 ).rgb;

	vec3 noise = noise_rgb/3.0f;
	//noise = pow( noise, vec3(1.0f/2.2f) );
	/* */

	//note: debug
	//outcol0 = vec4( noise.rgb, 1 );
	//return;

	noise = 2 * noise - 1;
	outcol0 = vec4( sample_col.rgb + opasity.xxx*noise.rgb, sample_col.a );
}
