layout(location = 0, index = 0) out vec4 outcol0;

uniform sampler2D tex0;
uniform vec4 tex0siz; //xy=size in pixels, zw = 1/xy
uniform vec4 radius;

in vec2 texcoord0_nm;

float nrand( vec2 n ) {
	return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}

vec2 rot2d( vec2 p, float a ) {
	vec2 sc = vec2(sin(a),cos(a));
	return vec2( dot( p, vec2(sc.y, -sc.x) ), dot( p, sc.xy ) );
}

void main(void)
{
	vec2 uv = texcoord0_nm;

	float maxofs = radius.x;
	const int NUM_SAMPLES = 8;
	const float NUM_SAMPLES_F = float(NUM_SAMPLES);
	const float anglestep = 6.28 / NUM_SAMPLES_F;
	const float MIPBIAS = -8.0; //note: make sure we always pick mip0

	//note: rand
	float rnd = nrand( 0.01*gl_FragCoord.xy /*+ fract(iGlobalTime)*/ );

	//note: ordered dither
	//float rnd = texture( iChannel1, gl_FragCoord.xy / 8.0 ).r;

	//note: create halfcircle of offsets
	vec2 ofs[NUM_SAMPLES];
	{
		float angle = 3.1416*rnd;
		for( int i=0, n=NUM_SAMPLES/2;i<n;++i )
		{
			ofs[i] = rot2d( vec2(maxofs,0.0), angle ) * tex0siz.zw;
			angle += anglestep;
		}
	}

	vec4 sum = vec4(0.0);
	//note: sample positive half-circle
	for( int i=0,n=NUM_SAMPLES/2; i<n; ++i )
		sum += texture( tex0, vec2(uv.x,uv.y)+ofs[i], MIPBIAS );

	//note: sample negative half-circle
	for( int i=0,n=NUM_SAMPLES/2; i<n; ++i )
		sum += texture( tex0, vec2(uv.x,uv.y)-ofs[i], MIPBIAS );

	outcol0.rgb = sum.rgb / NUM_SAMPLES_F;
	outcol0.a = 1.0;

	outcol0.rgb += nrand( uv /*+time*/ ) / 255.0;
}
