vec3 BayDidIt( const vec3 in_col ) {
	//const float blueHue = 201.0f;
	//const float tealHue = 34.0f;
	const float blueHue = 150.0f / 255.0f;
	const float tealHue = 20.0f / 255.0f;
	float tmp1 = blueHue / 255.0f * 2 * 3.14159265f;
	float tmp2 = tealHue / 255.0f * 2 * 3.14159265f;
	vec2 vblue = vec2( cos(tmp1), sin(tmp1) );
	vec2 vteal = vec2( cos(tmp2), sin(tmp2) );
	
	vec2 vdiff = normalize(vblue - vteal); //( (1=blue, -1=teal)
	
	vec3 hsv = RGBToHSL( in_col );
	float tmp3 = hsv.x / 255.0f * 2 * 3.14159265f;
	vec2 v = vec2(cos(tmp3), sin(tmp3));
	float t = dot( v, vdiff );
	t = clamp( 255.0f*t, -1.0f, 1.0f );
	hsv.x = mix( tealHue, blueHue, t*0.5f+0.5f);
	hsv.y = abs(t);
	
	return HSLToRGB( hsv );
}



vec3 iLoveOrangeAndTeal( const vec3 in_col )
{
	const float blueHue = 137.0f / 255.0f;
	const float tealHue = 19.0f / 255.0f;
	float t1 = blueHue / 255.0f * 2.0f * 3.14159265f;
	float t2 = tealHue / 255.0f * 2.0f * 3.14159265f;
	vec2 vblue = vec2( cos(t1), sin(t1) );
	vec2 vteal = vec2( cos(t2), sin(t2) );

	vec2 vdiff = normalize(vblue - vteal); //( (1=blue, -1=teal)

	vec3 hsv = RGBToHSL( in_col );
	float t3 = hsv.x / 255.0f * 2 * 3.14159265f;
	vec2 v = vec2(cos(t3), sin(t3));
	float t = dot( v, vdiff );
	t = clamp( 255.0f*t, -1.0f, 1.0f );
	hsv.x = mix( tealHue, blueHue, t*0.5f+0.5f);
	hsv.y = abs(t);

	return HSLToRGB( hsv );
}
