
layout(location = 0) in vec3 os_pos;
layout(location = 1) in vec3 os_norm;
layout(location = 2) in vec2 os_texcoord0;

uniform mat4 o_to_k; //obj to kaleido
uniform mat4 k_to_w; //kaleido to world
uniform mat4 vp;
uniform vec4 ws_its_plane;
uniform vec4 plane_its;

uniform vec4 ks_planeeq0;
uniform vec4 ks_planeeq1;
uniform vec4 ks_planeeq2;

out vec3 v2f_os_pos;
out vec3 ks_pos;
out vec3 ws_pos;
out vec2 uv0;
out float its;

//remaps interval [a;b] to [0;1]
float remap( float t, float a, float b ) {
	return clamp( (t - a) / (b - a), 0, 1 );
}

// \/ [0;1]
float sawtooth( float t ) {
	return abs(mod(abs(t), 2.0f)-1.0f);
}

void main()
{
	v2f_os_pos = os_pos;
	ks_pos = (o_to_k * vec4( os_pos, 1 )).xyz;
	ws_pos = (k_to_w * vec4( ks_pos, 1 )).xyz; //TODO: remove this, vp should be mvp

	gl_Position = vp * vec4( ws_pos, 1.0f );

	uv0 = os_texcoord0;

	float plane_dist = dot( vec4(ws_pos,1), ws_its_plane );
	its = 1-sawtooth( 2*remap( plane_dist, -0.25, 0.25 ) );
	its *= its;
	its *= plane_its.x;

	gl_ClipDistance[0] = dot( ks_planeeq0.xyz, ks_pos );
	gl_ClipDistance[1] = dot( ks_planeeq1.xyz, ks_pos );
	gl_ClipDistance[2] = dot( ks_planeeq2.xyz, ks_pos );
}
