

layout(location = 0, index = 0) out vec4 out_color0;

uniform vec4 debug_color;

in vec2 pos;

//remaps interval [a;b] to [0;1]
float remap( float t, float a, float b ) {
	return clamp( (t - a) / (b - a), 0, 1 );
}

//vec3 frq_to_color( float x )
//{
//	vec3 ret;
//	ret.x = remap( x, 0.0, 0.25 );
//	ret.y = remap( x, 0.25, 0.5 );
//	ret.z = remap( x, 0.5, 1.0 );
//	return ret;
//}

vec3 amp_to_color( float t )  {
	vec3 scl;
	scl.x = remap( t, 0.0, 0.05 );
	scl.y = remap( t, 0.05, 0.25 );
	scl.z = remap( t, 0.25, 1.0 );

	vec3 ret = vec3(0);
	ret += scl.x * vec3( 0.25f, 0.3f, 1.0f );
	ret += scl.y * vec3( 1, 0, 0 );
	ret += scl.z * vec3( 0, 1, 0 );

	return ret;
}


void main()
{
	float height = pos.y;
	//out_color0.rgb = debug_color.rgb;
	out_color0.rgb = amp_to_color( pos.y );
	out_color0.a = 1;
}
