

layout(location = 0, index = 0) out vec4 outcol0;

uniform vec4 diffcol;
uniform sampler2D aotex;

uniform vec4 parms;


in vec3 ws_norm;
in vec3 ws_lightvec;
in vec2 uv0;


//remaps interval [a;b] to [0;1]
float remap( float t, float a, float b ) {
	return clamp( (t - a) / (b - a), 0, 1 );
}


void main()
{
	float n_dot_l = clamp( dot( normalize(ws_norm), normalize(ws_lightvec) ), 0, 1 );
	//outcol0 = vec4( diffcol.rgb * vec3(n_dot_l), diffcol.a );

	float ao_sample = sqrt( texture( aotex, uv0 ).x );

	float c0 = remap( 1-ao_sample, 0.0, mix(0.5,1.0,1-parms.x) );
	float c1 = pow( 1.3 - n_dot_l, 4 );

	outcol0 = vec4( vec3(c0), 1 );
}
