/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XComposeStatus
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return XlibWrapper.dataModel == 32 ? 8 : 16;
    }

    @Override
    public int getDataSize() {
        return XComposeStatus.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XComposeStatus(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XComposeStatus() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XComposeStatus.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public long get_compose_ptr(int n) {
        log.finest("");
        return Native.getLong(this.pData + 0L) + (long)(n * Native.getLongSize());
    }

    public long get_compose_ptr() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_compose_ptr(long l) {
        log.finest("");
        Native.putLong(this.pData + 0L, l);
    }

    public int get_chars_matched() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8));
    }

    public void set_chars_matched(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8), n);
    }

    @Override
    String getName() {
        return "XComposeStatus";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("compose_ptr = ").append(this.get_compose_ptr()).append(", ");
        stringBuilder.append("chars_matched = ").append(this.get_chars_matched()).append(", ");
        return stringBuilder.toString();
    }
}

