define(["three", "camera", "skySphere", "meshTree", "util", "random", "objects", "util"],
    function(THREE, camera, skySphere, MeshTree, Util, Random, objects, util) {
        var scene = new THREE.Scene();

        var hat, material;

        var meshTree, branch;

        var light, hemiLight;

        var textPlane;
        var textMaterial;
        var textPlaneMesh;

        var sceneTime = 0;

        scene.init = function() {
            light = new THREE.SpotLight(0xFFFFFF, 2);
            light.position.set(-5, 10, 0);

            hemiLight = new THREE.HemisphereLight(0xFFFFFF, 0x666666, 1);   

            var textPlaneMesh = objects.textPlane.clone();
            textPlaneMesh.position.set(40, 0, 0);

            meshTree = new MeshTree();
            branch = meshTree.rootBranch;
            branch.random = new Random(592782);
            branch.position.setY(-20);
            branch.mesh = objects.hat.clone();
            branch.generate();
            branch.meshes[0].rotation.set(0, 0, Math.PI);
            branch.recurse();
            
            branch.add(textPlaneMesh);
            
            scene.add(branch);
            scene.add(hemiLight);
            scene.add(skySphere.clone());
            scene.add(light);
        }

        scene.enter = function() {
            branch.rotation.y = Math.PI * 1.3;
            camera.position.set(30, -20, 60);
            camera.rotation.set(0, 0, 0);
            sceneTime = 0;
        }

        scene.update = function(t, dt) {
            sceneTime += dt;
            var end = util.beatsToTime(130, {bars: 0, beats: 2, eights: 0});
            if(sceneTime < end)
            {                
                this.fadeAmount = (end - sceneTime) / end;
            }
            else
            {
                this.fadeAmount = 0;
            }

            var brot = branch.rotation.y;
            brot += dt * 0.8;
            branch.rotation.y = brot;
        }

        return scene;
    });
                  