/*
 * Decompiled with CFR 0.152.
 */
package toxi.physics.constraints;

import toxi.geom.AABB;
import toxi.geom.Ray3D;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Vec3D;
import toxi.physics.VerletParticle;
import toxi.physics.constraints.ParticleConstraint;

public class BoxConstraint
implements ParticleConstraint {
    protected AABB box;
    protected Ray3D intersectRay;
    private float restitution = 1.0f;

    public BoxConstraint(AABB aABB) {
        this.box = aABB.copy();
        this.intersectRay = new Ray3D((ReadonlyVec3D)aABB, (ReadonlyVec3D)new Vec3D());
    }

    public BoxConstraint(Vec3D vec3D, Vec3D vec3D2) {
        this(AABB.fromMinMax((Vec3D)vec3D, (Vec3D)vec3D2));
    }

    public void apply(VerletParticle verletParticle) {
        if (verletParticle.isInAABB(this.box)) {
            Vec3D vec3D = verletParticle.getVelocity();
            Vec3D vec3D2 = verletParticle.getPreviousPosition();
            if (vec3D2.isInAABB(this.box)) {
                vec3D.invert();
            }
            this.intersectRay.set(vec3D2);
            this.intersectRay.setDirection((ReadonlyVec3D)vec3D);
            Vec3D vec3D3 = this.box.intersectsRay(this.intersectRay, 0.0f, Float.MAX_VALUE);
            if (vec3D3 != null) {
                vec3D3.addSelf(this.box.getNormalForPoint((ReadonlyVec3D)vec3D3).scaleSelf(0.01f));
                verletParticle.setPreviousPosition(vec3D3);
                verletParticle.set(vec3D3.sub(vec3D.scaleSelf(this.restitution)));
            }
        }
    }

    public AABB getBox() {
        return this.box.copy();
    }

    public float getRestitution() {
        return this.restitution;
    }

    public void setBox(AABB aABB) {
        this.box = aABB.copy();
        this.intersectRay.set((Vec3D)aABB);
    }

    public void setRestitution(float f) {
        this.restitution = f;
    }
}

