/*
 * Decompiled with CFR 0.152.
 */
package toxi.physics;

import java.util.ArrayList;
import java.util.List;
import toxi.geom.AABB;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Vec3D;
import toxi.physics.VerletParticle;
import toxi.physics.VerletSpring;
import toxi.physics.behaviors.GravityBehavior;
import toxi.physics.behaviors.ParticleBehavior;
import toxi.physics.constraints.ParticleConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerletPhysics {
    public List<VerletParticle> particles;
    public List<VerletSpring> springs;
    protected float timeStep;
    protected int numIterations;
    protected AABB worldBounds;
    public final List<ParticleBehavior> behaviors = new ArrayList<ParticleBehavior>(1);
    protected float drag;

    public static void addConstraintToAll(ParticleConstraint particleConstraint, List<VerletParticle> list) {
        for (VerletParticle verletParticle : list) {
            verletParticle.addConstraint(particleConstraint);
        }
    }

    public static void removeConstraintFromAll(ParticleConstraint particleConstraint, List<VerletParticle> list) {
        for (VerletParticle verletParticle : list) {
            verletParticle.removeConstraint(particleConstraint);
        }
    }

    public VerletPhysics() {
        this(null, 50, 0.0f, 1.0f);
    }

    public VerletPhysics(Vec3D vec3D, int n, float f, float f2) {
        this.particles = new ArrayList<VerletParticle>();
        this.springs = new ArrayList<VerletSpring>();
        if (vec3D != null) {
            this.addBehavior(new GravityBehavior(vec3D));
        }
        this.numIterations = n;
        this.timeStep = f2;
        this.setDrag(f);
    }

    public void addBehavior(ParticleBehavior particleBehavior) {
        particleBehavior.configure(this.timeStep);
        this.behaviors.add(particleBehavior);
    }

    public VerletPhysics addParticle(VerletParticle verletParticle) {
        this.particles.add(verletParticle);
        return this;
    }

    public VerletPhysics addSpring(VerletSpring verletSpring) {
        if (this.getSpring(verletSpring.a, verletSpring.b) == null) {
            this.springs.add(verletSpring);
        }
        return this;
    }

    public VerletPhysics clear() {
        this.particles.clear();
        this.springs.clear();
        return this;
    }

    protected void constrainToBounds() {
        for (VerletParticle verletParticle : this.particles) {
            if (verletParticle.bounds == null) continue;
            verletParticle.constrain(verletParticle.bounds);
        }
        if (this.worldBounds != null) {
            for (VerletParticle verletParticle : this.particles) {
                verletParticle.constrain(this.worldBounds);
            }
        }
    }

    public AABB getCurrentBounds() {
        Vec3D vec3D = new Vec3D(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        Vec3D vec3D2 = new Vec3D(Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE);
        for (VerletParticle verletParticle : this.particles) {
            vec3D.minSelf((ReadonlyVec3D)verletParticle);
            vec3D2.maxSelf((ReadonlyVec3D)verletParticle);
        }
        return AABB.fromMinMax((Vec3D)vec3D, (Vec3D)vec3D2);
    }

    public float getDrag() {
        return 1.0f - this.drag;
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public VerletSpring getSpring(Vec3D vec3D, Vec3D vec3D2) {
        for (VerletSpring verletSpring : this.springs) {
            if ((verletSpring.a != vec3D || verletSpring.b != vec3D2) && (verletSpring.a != vec3D2 || verletSpring.b != vec3D)) continue;
            return verletSpring;
        }
        return null;
    }

    public float getTimeStep() {
        return this.timeStep;
    }

    public AABB getWorldBounds() {
        return this.worldBounds;
    }

    public boolean removeBehavior(ParticleBehavior particleBehavior) {
        return this.behaviors.remove(particleBehavior);
    }

    public boolean removeParticle(VerletParticle verletParticle) {
        return this.particles.remove((Object)verletParticle);
    }

    public boolean removeSpring(VerletSpring verletSpring) {
        return this.springs.remove(verletSpring);
    }

    public boolean removeSpringElements(VerletSpring verletSpring) {
        if (this.removeSpring(verletSpring)) {
            return this.removeParticle(verletSpring.a) && this.removeParticle(verletSpring.b);
        }
        return false;
    }

    public void setDrag(float f) {
        this.drag = 1.0f - f;
    }

    public void setNumIterations(int n) {
        this.numIterations = n;
    }

    public void setTimeStep(float f) {
        this.timeStep = f;
        for (ParticleBehavior particleBehavior : this.behaviors) {
            particleBehavior.configure(f);
        }
    }

    public VerletPhysics setWorldBounds(AABB aABB) {
        this.worldBounds = aABB;
        return this;
    }

    public VerletPhysics update() {
        this.updateParticles();
        this.updateSprings();
        this.constrainToBounds();
        return this;
    }

    protected void updateParticles() {
        for (ParticleBehavior object : this.behaviors) {
            for (VerletParticle verletParticle : this.particles) {
                object.apply(verletParticle);
            }
        }
        for (VerletParticle verletParticle : this.particles) {
            verletParticle.scaleVelocity(this.drag);
            verletParticle.update();
        }
    }

    protected void updateSprings() {
        for (int i = this.numIterations; i > 0; --i) {
            for (VerletSpring verletSpring : this.springs) {
                verletSpring.update(i == 1);
            }
        }
    }
}

