/*
 * Decompiled with CFR 0.152.
 */
package toxi.physics;

import java.util.ArrayList;
import java.util.List;
import toxi.geom.AABB;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Vec3D;
import toxi.physics.behaviors.ParticleBehavior;
import toxi.physics.constraints.ParticleConstraint;

public class VerletParticle
extends Vec3D {
    protected Vec3D prev;
    protected Vec3D temp;
    protected boolean isLocked;
    public AABB bounds;
    public List<ParticleConstraint> constraints;
    public List<ParticleBehavior> behaviors;
    protected float weight;
    protected float invWeight;
    protected Vec3D force = new Vec3D();

    public VerletParticle(float f, float f2, float f3) {
        this(f, f2, f3, 1.0f);
    }

    public VerletParticle(float f, float f2, float f3, float f4) {
        super(f, f2, f3);
        this.prev = new Vec3D((ReadonlyVec3D)this);
        this.temp = new Vec3D();
        this.setWeight(f4);
    }

    public VerletParticle(ReadonlyVec3D readonlyVec3D) {
        this(readonlyVec3D.x(), readonlyVec3D.y(), readonlyVec3D.z(), 1.0f);
    }

    public VerletParticle(ReadonlyVec3D readonlyVec3D, float f) {
        this(readonlyVec3D.x(), readonlyVec3D.y(), readonlyVec3D.z(), f);
    }

    public VerletParticle(VerletParticle verletParticle) {
        this(verletParticle.x, verletParticle.y, verletParticle.z, verletParticle.weight);
        this.isLocked = verletParticle.isLocked;
    }

    public VerletParticle addBehavior(ParticleBehavior particleBehavior) {
        return this.addBehavior(particleBehavior, 1.0f);
    }

    public VerletParticle addBehavior(ParticleBehavior particleBehavior, float f) {
        if (this.behaviors == null) {
            this.behaviors = new ArrayList<ParticleBehavior>(1);
        }
        particleBehavior.configure(f);
        this.behaviors.add(particleBehavior);
        return this;
    }

    public VerletParticle addConstraint(ParticleConstraint particleConstraint) {
        if (this.constraints == null) {
            this.constraints = new ArrayList<ParticleConstraint>(1);
        }
        this.constraints.add(particleConstraint);
        return this;
    }

    public VerletParticle addForce(Vec3D vec3D) {
        this.force.addSelf(vec3D);
        return this;
    }

    public VerletParticle addVelocity(Vec3D vec3D) {
        this.prev.subSelf(vec3D);
        return this;
    }

    public void applyBehaviors() {
        if (this.behaviors != null) {
            for (ParticleBehavior particleBehavior : this.behaviors) {
                particleBehavior.apply(this);
            }
        }
    }

    public void applyConstraints() {
        if (this.constraints != null) {
            for (ParticleConstraint particleConstraint : this.constraints) {
                particleConstraint.apply(this);
            }
        }
    }

    protected void applyForce() {
        this.temp.set((Vec3D)this);
        this.addSelf(this.sub(this.prev).addSelf(this.force.scale(this.weight)));
        this.prev.set(this.temp);
        this.force.clear();
    }

    public VerletParticle clearConstraints() {
        this.constraints.clear();
        return this;
    }

    public VerletParticle clearForce() {
        this.force.clear();
        return this;
    }

    public VerletParticle clearVelocity() {
        this.prev.set((Vec3D)this);
        return this;
    }

    public final float getInvWeight() {
        return this.invWeight;
    }

    public Vec3D getPreviousPosition() {
        return this.prev;
    }

    public Vec3D getVelocity() {
        return this.sub(this.prev);
    }

    public final float getWeight() {
        return this.weight;
    }

    public final boolean isLocked() {
        return this.isLocked;
    }

    public VerletParticle lock() {
        this.isLocked = true;
        return this;
    }

    public boolean removeBehavior(ParticleBehavior particleBehavior) {
        return this.behaviors.remove(particleBehavior);
    }

    public boolean removeConstraint(ParticleConstraint particleConstraint) {
        return this.constraints.remove(particleConstraint);
    }

    public VerletParticle scaleVelocity(float f) {
        this.prev.interpolateToSelf((ReadonlyVec3D)this, 1.0f - f);
        return this;
    }

    public VerletParticle setPreviousPosition(Vec3D vec3D) {
        this.prev.set(vec3D);
        return this;
    }

    public void setWeight(float f) {
        this.weight = f;
        this.invWeight = 1.0f / f;
    }

    public VerletParticle unlock() {
        this.clearVelocity();
        this.isLocked = false;
        return this;
    }

    public void update() {
        if (!this.isLocked) {
            this.applyBehaviors();
            this.applyForce();
            this.applyConstraints();
        }
    }
}

