/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom.mesh;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import toxi.geom.Vec3D;
import toxi.geom.mesh.DefaultSTLColorModel;
import toxi.geom.mesh.MaterialiseSTLColorModel;
import toxi.geom.mesh.STLColorModel;

public class STLWriter {
    protected static final Logger logger = Logger.getLogger(STLWriter.class.getName());
    public static final int DEFAULT_RGB = -1;
    public static final STLColorModel DEFAULT = new DefaultSTLColorModel();
    public static final STLColorModel MATERIALISE = new MaterialiseSTLColorModel(-1);
    public static final int DEFAULT_BUFFER = 65536;
    protected OutputStream ds;
    protected byte[] buf = new byte[4];
    protected int bufferSize;
    protected Vec3D scale = new Vec3D(1.0f, 1.0f, 1.0f);
    protected boolean useInvertedNormals = false;
    protected STLColorModel colorModel;

    public STLWriter() {
        this(DEFAULT, 65536);
    }

    public STLWriter(STLColorModel sTLColorModel, int n) {
        this.colorModel = sTLColorModel;
        this.bufferSize = n;
    }

    public void beginSave(OutputStream outputStream, int n) {
        logger.info("starting to save STL data to output stream...");
        try {
            this.ds = new BufferedOutputStream(new DataOutputStream(outputStream), this.bufferSize);
            this.writeHeader(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void beginSave(String string, int n) {
        logger.info("saving mesh to: " + string);
        try {
            this.beginSave(new FileOutputStream(string), n);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public void endSave() {
        try {
            this.ds.flush();
            this.ds.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void face(Vec3D vec3D, Vec3D vec3D2, Vec3D vec3D3) {
        this.face(vec3D, vec3D2, vec3D3, -1);
    }

    public void face(Vec3D vec3D, Vec3D vec3D2, Vec3D vec3D3, int n) {
        Vec3D vec3D4 = vec3D2.sub(vec3D).crossSelf(vec3D3.sub(vec3D)).normalize();
        if (this.useInvertedNormals) {
            vec3D4.invert();
        }
        this.face(vec3D, vec3D2, vec3D3, vec3D4, n);
    }

    public void face(Vec3D vec3D, Vec3D vec3D2, Vec3D vec3D3, Vec3D vec3D4, int n) {
        try {
            this.writeVector(vec3D4);
            this.writeScaledVector(vec3D);
            this.writeScaledVector(vec3D2);
            this.writeScaledVector(vec3D3);
            if (n != -1) {
                this.writeShort(this.colorModel.formatRGB(n));
            } else {
                this.writeShort(this.colorModel.getDefaultRGB());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private final void prepareBuffer(int n) {
        this.buf[3] = (byte)(n >>> 24);
        this.buf[2] = (byte)(n >> 16 & 0xFF);
        this.buf[1] = (byte)(n >> 8 & 0xFF);
        this.buf[0] = (byte)(n & 0xFF);
    }

    public void setScale(float f) {
        this.scale.set(f, f, f);
    }

    public void setScale(Vec3D vec3D) {
        this.scale.set(vec3D);
    }

    public void useInvertedNormals(boolean bl) {
        this.useInvertedNormals = bl;
    }

    protected void writeFloat(float f) throws IOException {
        this.prepareBuffer(Float.floatToRawIntBits(f));
        this.ds.write(this.buf, 0, 4);
    }

    protected void writeHeader(int n) throws IOException {
        byte[] byArray = new byte[80];
        this.colorModel.formatHeader(byArray);
        this.ds.write(byArray, 0, 80);
        this.writeInt(n);
    }

    protected void writeInt(int n) throws IOException {
        this.prepareBuffer(n);
        this.ds.write(this.buf, 0, 4);
    }

    protected void writeScaledVector(Vec3D vec3D) {
        try {
            this.writeFloat(vec3D.x * this.scale.x);
            this.writeFloat(vec3D.y * this.scale.y);
            this.writeFloat(vec3D.z * this.scale.z);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void writeShort(int n) throws IOException {
        this.buf[0] = (byte)(n & 0xFF);
        this.buf[1] = (byte)(n >> 8 & 0xFF);
        this.ds.write(this.buf, 0, 2);
    }

    protected void writeVector(Vec3D vec3D) {
        try {
            this.writeFloat(vec3D.x);
            this.writeFloat(vec3D.y);
            this.writeFloat(vec3D.z);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

