/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import toxi.geom.Intersector3D;
import toxi.geom.IsectData3D;
import toxi.geom.Ray3D;
import toxi.geom.Triangle3D;
import toxi.geom.Vec3D;

public class TriangleIntersector
implements Intersector3D {
    public Triangle3D triangle;
    private IsectData3D isectData;

    public TriangleIntersector() {
        this(new Triangle3D());
    }

    public TriangleIntersector(Triangle3D triangle3D) {
        this.triangle = triangle3D;
        this.isectData = new IsectData3D();
    }

    public IsectData3D getIntersectionData() {
        return this.isectData;
    }

    public Triangle3D getTriangle() {
        return this.triangle;
    }

    public boolean intersectsRay(Ray3D ray3D) {
        this.isectData.isIntersection = false;
        Vec3D vec3D = this.triangle.computeNormal();
        float f = vec3D.dot(ray3D.dir);
        if (f < 0.0f) {
            Vec3D vec3D2 = ray3D.sub(this.triangle.a);
            float f2 = -(vec3D.x * vec3D2.x + vec3D.y * vec3D2.y + vec3D.z * vec3D2.z) / (vec3D.x * ray3D.dir.x + vec3D.y * ray3D.dir.y + vec3D.z * ray3D.dir.z);
            if (f2 >= 1.1920929E-7f) {
                Vec3D vec3D3 = ray3D.getPointAtDistance(f2);
                this.isectData.isIntersection = true;
                this.isectData.pos = vec3D3;
                this.isectData.normal = vec3D;
                this.isectData.dist = f2;
                this.isectData.dir = this.isectData.pos.sub(ray3D).normalize();
            }
        }
        return this.isectData.isIntersection;
    }

    protected boolean isSameClockDir(Vec3D vec3D, Vec3D vec3D2, Vec3D vec3D3, Vec3D vec3D4) {
        float f = (vec3D2.y - vec3D.y) * (vec3D3.z - vec3D.z) - (vec3D3.y - vec3D.y) * (vec3D2.z - vec3D.z);
        float f2 = (vec3D2.z - vec3D.z) * (vec3D3.x - vec3D.x) - (vec3D3.z - vec3D.z) * (vec3D2.x - vec3D.x);
        float f3 = (vec3D2.x - vec3D.x) * (vec3D3.y - vec3D.y) - (vec3D3.x - vec3D.x) * (vec3D2.y - vec3D.y);
        float f4 = f * vec3D4.x + f2 * vec3D4.y + f3 * vec3D4.z;
        return f4 < 0.0f;
    }

    public TriangleIntersector setTriangle(Triangle3D triangle3D) {
        this.triangle = triangle3D;
        return this;
    }
}

