/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.AudioMetaData;
import ddf.minim.javasound.BasicMetaData;
import ddf.minim.javasound.FloatSampleBuffer;
import ddf.minim.javasound.JSMinim;
import ddf.minim.javasound.JSPCMAudioRecordingStream;
import ddf.minim.spi.AudioRecordingStream;
import ddf.minim.spi.SampleRecorder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;
import org.tritonus.share.sampled.AudioUtils;

final class JSBufferedSampleRecorder
implements SampleRecorder {
    private ArrayList<FloatBuffer> buffers;
    private FloatBuffer left;
    private FloatBuffer right;
    private boolean recording;
    private String name;
    private AudioFileFormat.Type type;
    private AudioFormat format;
    private JSMinim system;

    JSBufferedSampleRecorder(JSMinim jSMinim, String string, AudioFileFormat.Type type, AudioFormat audioFormat, int n) {
        this.name = string;
        this.type = type;
        this.format = audioFormat;
        this.buffers = new ArrayList(20);
        this.left = FloatBuffer.allocate(n * 10);
        this.right = this.format.getChannels() == 2 ? FloatBuffer.allocate(n * 10) : null;
        this.system = jSMinim;
    }

    public String filePath() {
        return this.name;
    }

    public AudioRecordingStream save() {
        Object object;
        Object object2;
        if (this.isRecording()) {
            this.system.error("You must stop recording before you can write to a file.");
        } else {
            Comparable<FloatBuffer> comparable;
            int n;
            int n2;
            int n3 = this.format.getChannels();
            int n4 = this.left.capacity();
            int n5 = this.buffers.size() / n3 * n4;
            FloatSampleBuffer floatSampleBuffer = new FloatSampleBuffer(n3, n5, this.format.getSampleRate());
            if (n3 == 1) {
                for (n2 = 0; n2 < this.buffers.size(); ++n2) {
                    n = n2 * n4;
                    object2 = this.buffers.get(n2);
                    ((FloatBuffer)object2).rewind();
                    ((FloatBuffer)object2).get(floatSampleBuffer.getChannel(0), n, n4);
                }
            } else {
                for (n2 = 0; n2 < this.buffers.size(); n2 += 2) {
                    n = n2 / 2 * n4;
                    object2 = this.buffers.get(n2);
                    comparable = this.buffers.get(n2 + 1);
                    ((FloatBuffer)object2).rewind();
                    ((FloatBuffer)object2).get(floatSampleBuffer.getChannel(0), n, n4);
                    ((FloatBuffer)comparable).rewind();
                    ((FloatBuffer)comparable).get(floatSampleBuffer.getChannel(1), n, n4);
                }
            }
            n2 = floatSampleBuffer.getByteArrayBufferSize(this.format) / this.format.getFrameSize();
            object = new ByteArrayInputStream(floatSampleBuffer.convertToByteArray(this.format));
            object2 = new AudioInputStream((InputStream)object, this.format, n2);
            if (AudioSystem.isFileTypeSupported(this.type, (AudioInputStream)object2)) {
                comparable = new File(this.name);
                try {
                    AudioSystem.write((AudioInputStream)object2, this.type, (File)comparable);
                }
                catch (IOException iOException) {
                    this.system.error("AudioRecorder.save: Error attempting to save buffer to " + this.name + "\n" + iOException.getMessage());
                }
                if (((File)comparable).length() == 0L) {
                    this.system.error("AudioRecorder.save: Error attempting to save buffer to " + this.name + ", the output file is empty.");
                }
            } else {
                this.system.error("AudioRecorder.save: Can't write " + this.type.toString() + " using format " + this.format.toString() + ".");
            }
        }
        String string = this.filePath();
        AudioInputStream audioInputStream = this.system.getAudioInputStream(string);
        SourceDataLine sourceDataLine = this.system.getSourceDataLine(audioInputStream.getFormat(), 1024);
        long l = AudioUtils.frames2Millis((long)audioInputStream.getFrameLength(), (AudioFormat)this.format);
        object = new BasicMetaData(string, l, audioInputStream.getFrameLength());
        object2 = new JSPCMAudioRecordingStream(this.system, (AudioMetaData)object, audioInputStream, sourceDataLine, 1024);
        return object2;
    }

    public void samples(float[] fArray) {
        if (this.recording) {
            this.left.put(fArray);
            if (!this.left.hasRemaining()) {
                this.buffers.add(this.left);
                this.left = FloatBuffer.allocate(this.left.capacity());
            }
        }
    }

    public void samples(float[] fArray, float[] fArray2) {
        if (this.recording) {
            this.left.put(fArray);
            this.right.put(fArray2);
            if (!this.left.hasRemaining()) {
                this.buffers.add(this.left);
                this.buffers.add(this.right);
                this.left = FloatBuffer.allocate(this.left.capacity());
                this.right = FloatBuffer.allocate(this.right.capacity());
            }
        }
    }

    public void beginRecord() {
        this.recording = true;
    }

    public void endRecord() {
        this.recording = false;
    }

    public boolean isRecording() {
        return this.recording;
    }
}

